#ifndef _CEGOAVLINDEXCURSOR_H_INCLUDED_
#define _CEGOAVLINDEXCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAVLIndexCursor.h
// -----------------
// Cego AVL index cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAVLIndexCursor
// 
// Description: Traversing through index
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoObject.h"
#include "CegoField.h"
#include "CegoAttrCond.h"
#include "CegoDataPointer.h"
#include "CegoTableManager.h"
#include "CegoQueryHelper.h"
#include "CegoAVLIndexEntry.h"

class CegoAVLIndexCursor {
    
public:
    
    CegoAVLIndexCursor(CegoTableManager* pTM, unsigned tabSetId, const Chain& indexName, CegoObject::ObjectType type, CegoAttrCond* pAttrCond, bool ignoreTouched, bool readUncommitted);
    ~CegoAVLIndexCursor();
    
    bool getFirst(ListT<CegoField>& fl, CegoDataPointer& dp);
    bool getNext(ListT<CegoField>& fl, CegoDataPointer& dp);
    
    void reset();	
    void abort();
    
private:

    CegoComparison compValue(char* idxVal);
    
    CegoAttrCond* _pAttrCond;

    CegoTableManager* _pTM;
    CegoAVLIndexEntry _ie;
    CegoDataPointer _rdp;
    CegoDataPointer _idp;

    Chain _indexName;
    CegoObject::ObjectType _type;
    bool _rootPassed;
    
    CegoBufferPage _rootPage;
    CegoBufferPage _currentPage;
    CegoBufferPage _dataPage;

    unsigned _tabSetId;

    bool _ignoreTouched;
    bool _readUncommitted;

    CegoQueryHelper _qh;

    bool _cursorCached;
    bool _eoc;
    unsigned int _lockId;
    
    unsigned _cachedLen;
    char* _cachedPointer;

    ListT<CegoField> _idxSchema;
};

#endif
