#ifndef _CEGOADMINTHREADPOOL_H_INCLUDED_
#define _CEGOADMINTHREADPOOL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdminThreadPool.h  
// ---------------------
// Cego threadpool class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdminThreadPool
// 
// Description: Thread pool implementation for admin message handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Thread.h>
#include <lfcbase/NetHandler.h>

// CEGO INCLUDES
#include "CegoDatabaseManager.h"
#include "CegoDbThreadPool.h"

class CegoAdminThread;

class CegoAdminThreadPool : public Thread {
    
public:

    enum ThreadState { READY, BUSY, CONNECTED };
  
    CegoAdminThreadPool();
    CegoAdminThreadPool(unsigned poolLimit, CegoDatabaseManager *pDBMng, CegoDbThreadPool *pDbPool);
    ~CegoAdminThreadPool();

    unsigned getPoolLimit() const;
    void* job(void* arg);

    void getThreadInfo(unsigned i, unsigned long long& numRequest, unsigned long long& threadLoad, ThreadState& state, Chain& action);
    void setState(unsigned i, ThreadState state);
    void setTid(unsigned i, unsigned long long tid);
    void incNumRequest(unsigned i);

    void addThreadIdle(unsigned i, unsigned long long usec);

    void dispatch();

    NetHandler* nextRequest();
    
    bool isTerminated();

    void getLockStat(Chain& lockName, unsigned& lockCount, unsigned long long &numRdLock, unsigned long long &numWrLock, unsigned long long &sumRdDelay, unsigned long long &sumWrDelay);
    
private:

    void lockQueue();
    void unlockQueue();
	
    unsigned long long* _threadId;
    unsigned long long* _numRequest;
    ThreadState* _threadState;

    unsigned long long* _threadIdle[THRMNG_NUMLOADSAMPLE];
    unsigned long long* _threadLoad;
    unsigned _samplePos;

    CegoAdminThread** _threadList;
    
    unsigned _poolLimit;
    Chain _adminHostName;
    unsigned _adminPortNo;

    bool _terminated;
    bool _joined;

    ListT<NetHandler*> _requestQueue;

    CegoDatabaseManager* _pDBMng;

    unsigned long _modId;
};
#endif
