#ifndef _CEGOARCHIVETHREAD_H_INCLUDED_
#define _CEGOARCHIVETHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoArchiveThread.h  
// --------------------
// Cego archive thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoMediatorThread
//
// Description: Dedicated thread for redo log file archiving
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/Logger.h>
#include <lfcbase/Thread.h>

// cego includes
#include "CegoDatabaseManager.h"

class CegoArchiveThread : public Thread {
    
 public:

    CegoArchiveThread(CegoDatabaseManager *pDBMng);
    ~CegoArchiveThread();

    void* job(void* arg);

    static void shiftActive(CegoDatabaseManager *pDBMng, const Chain& tableSet);
    
private:

    void shiftRedoLogs();

    static void copyLog(CegoDatabaseManager* pDBMng, const Chain& tableSet, const Chain& logFileName, const Chain& archLogPath);

    
    CegoDatabaseManager *_pDBMng;
    bool _terminated;
    bool _joined;

    unsigned long _modId;
};
#endif







