#ifndef _CEGOATTRALIAS_H_INCLUDED_
#define _CEGOATTRALIAS_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrAlias.h
// ---------------
// Cego table attribute alias class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAttrDesc
// 
// Description: Table attribute alias container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcxml/Element.h>

// CEGO INCLUDES
#include "CegoContentObject.h"
#include "CegoField.h"

class CegoDatabaseFormater;

class CegoAttrAlias {

public:

    CegoAttrAlias();
    CegoAttrAlias(const Chain& aliasName);
    CegoAttrAlias(const Chain& attrName, const Chain& aliasName);
    ~CegoAttrAlias();

    void setAttrName(const Chain& attrName);
    const Chain& getAttrName() const;

    void setAliasName(const Chain& aliasName);
    const Chain& getAliasName() const;

    CegoAttrAlias* clone() const;

    CegoAttrAlias& operator = ( const CegoAttrAlias& ad);
    bool operator == ( const CegoAttrAlias& ad) const;
    bool operator != ( const CegoAttrAlias& ad) const;

    Chain getId() const;
    Chain toChain() const;
	
    Element* toElement() const;
    void fromElement(Element *pAttrAliasElement);

    void encode(char *buf);
    void decode(char *buf);
    unsigned getEncodingLength() const;
    
    friend ostream& operator << (ostream& s, const CegoAttrAlias& a);
    
private:
    
    Chain _attrName;  
    Chain _aliasName;
};
#endif
