#ifndef _CEGOCHECKPOINT_H_INCLUDED_
#define _CEGOCHECKPOINT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCheckpoint.h
// ----------------
// Cego checkpoint class definition
//        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoCheckpoint
// 
// Description: 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

class CegoCheckpoint {

public:
   
    CegoCheckpoint();
    ~CegoCheckpoint();

    bool checkpointReached(const Chain& tableSet, unsigned interval);

 private:

    class CheckpointEntry {

    public:

	CheckpointEntry() { };
	CheckpointEntry(const Chain& ts) { _ts = ts; };
	CheckpointEntry(const Chain& ts, unsigned long long nextCP) { _ts = ts; _nextCP = nextCP; };
	~CheckpointEntry() {};
	       
	long long getNextCP() { return _nextCP; };
	void setNextCP(long long nextCP) { _nextCP = nextCP; };

	CheckpointEntry& operator = ( const CheckpointEntry& cp) { 
	    _ts = cp._ts;
	    _nextCP = cp._nextCP;
	    return *this;
	};
	
	bool operator == ( const CheckpointEntry& cp) {
	    return _ts == cp._ts;
	};
	
    private:
	Chain _ts;
	long long _nextCP;
    };

    ListT<CheckpointEntry> _tsList;
};
#endif
