#ifndef _CEGOFACTOR_H_INCLUDED_
#define _CEGOFACTOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoFactor.h
// ------------
// Cego factor structure class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoFactor
// 
// Description: Container class to describe a factor element 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>
#include <lfcxml/Element.h>

// CEGO INCLUDES
#include "CegoFieldValue.h"
#include "CegoProcBlock.h"
#include "CegoProcFetch.h"
#include "CegoFunction.h"
#include "CegoAggregation.h"

class CegoQueryManager;
class CegoExpr;
class CegoSelect;
class CegoCaseCond;
class CegoCondition;

class CegoFactor {
    
 public:
    
    enum FacType { CONSTVAL, VAR, EXPR, FETCH, ATTR, FUNCTION, QUERY, AGGREGATION, CASECOND, CONDITION };

    CegoFactor(char* buf, CegoQueryManager *pGTM, CegoProcBlock *pBlock, unsigned tabSetId);
    CegoFactor(const CegoFactor& pf);
    CegoFactor(const Chain& varName);
    CegoFactor(const CegoFieldValue& fv);
    CegoFactor(CegoAttrDesc* pAttrDesc, bool isAttrRef = false);
    CegoFactor(CegoExpr* pExpr);
    CegoFactor(CegoProcFetch* pFetch);
    CegoFactor(CegoFunction* pFunction);
    CegoFactor(CegoAggregation* pAggr);
    CegoFactor(CegoSelect* pSelect);
    CegoFactor(CegoCaseCond* pCaseCond);
    CegoFactor(CegoCondition* pCond);

    ~CegoFactor();

    void cleanUp();

    void setTabSetId(unsigned tabSetId);
    
    void clearAttrCache();

    void getFunctionList(SetT<CegoObject>& funcList);

    bool checkConst() const;
    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;
    CegoCondition* checkCondition() const;
    
    bool checkLob(CegoFieldValue& fv, CegoProcBlock *pBlock);

    void getSelectQueryList(ListT<CegoSelect*>& queryList);
    
    CegoAttrDesc* getAttr() const;
    CegoFunction* getFunction() const;
    CegoAggregation* getAggregation() const;
    CegoSelect* getSelect() const;
    CegoCaseCond* getCaseCond() const;
    CegoCondition* getCondition() const;

    CegoCondition* grapCondition();

    void getFieldList(ListT<CegoField>& fl, ListT<CegoField>** pFLA) const;

    ListT<CegoAttrDesc*> getAttrRefList() const;
    unsigned evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    
    CegoField evalField(const ListT<CegoField>& fl, bool graceful = false) const;

    CegoFieldValue evalFieldValue(ListT<CegoField>** pFLA, CegoProcBlock *pBlock);

    const Chain& getVarName() const;
    const CegoFieldValue& getFieldValue() const;

    const FacType getType() const;
    CegoExpr* getExpr() const;

    CegoFactor* clone(bool isAttrRef = false);

    CegoFactor& operator = ( const CegoFactor& pf);

    Chain getId(CegoProcBlock *pBlock) const;
    Chain toChain(unsigned defTabSetId, const Chain& indent) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
    void encode(char *buf, CegoProcBlock *pBlock);
    void decode(char *buf, CegoQueryManager* pGTM, CegoProcBlock *pBlock, unsigned tabSetId);
    unsigned getEncodingLength(CegoProcBlock *pBlock) const;

    ListT<CegoAggregation*> getAggregationList();

    void getPlanList(ListT<Element*>& planList);

    friend ostream& operator << (ostream& s, const CegoFactor& pf);

    CegoFactor* map(const Chain& viewAlias, const ListT<CegoExpr*>& exprList) const;
    
 private:
    
    CegoFieldValue _fv;
    FacType _type;
    CegoAttrDesc* _pAttrDesc;
    bool _isAttrRef;
    Chain _varName;
    CegoExpr* _pExpr;
    CegoProcFetch *_pFetch;
    CegoFunction* _pFunction;
    CegoAggregation* _pAggr;
    CegoSelect* _pSelect;
    CegoCaseCond* _pCaseCond;
    CegoCondition* _pCond;    
    unsigned _flaCacheArrayPos;
    unsigned _flaCacheFieldPos;
    bool _flaCached;
};
#endif
