///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoModule.cc
// -------------
// Cego module implementation
//     
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoModule
// 
// Description: Program module class for log messaging support
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>
// CEGO INCLUDES
#include "CegoModule.h"

const char *CEGO_MODULE_MAP[] =
{
    "None",
    "CegoMain",
    "CegoDbThread",
    "CegoAction",
    "CegoDbHandler",
    "CegoSelect",
    "CegoXPorter",
    "CegoTableManager",
    "CegoTableCursor",
    "CegoObjectManager",
    "CegoSystemObject",
    "CegoBufferPool",
    "CegoLogManager",
    "CegoAdminThread",
    "CegoObjectCursor",
    "CegoAVLIndexManager",
    "CegoImpInStream",
    "CegoExpOutStream",
    "CegoFileHandler",
    "CegoDatabaseManager",
    "CegoArchiveThread",
    "CegoQueryManager",
    "CegoRecoveryManager",
    "CegoDbThreadPool",
    "CegoAdminThreadPool",
    "CegoSigCatch",
    "CegoQueryHandler",
    "CegoQueryCursor",
    "CegoAdminHandler",
    "CegoTransactionManager",
    "CegoLockHandler",
    "CegoBTreeManager",
    "CegoBTreeCursor",
    "CegoXMLSpace",
    // just for client programs
    "CegoClient",
    "CegoAdmin",
    "CegoAdmAction",
    "CegoOutput",
    "cgwrap"
};

CegoModule::CegoModule() : Logger()
{
}

CegoModule::CegoModule(const Chain& logFile, const Chain& progName) : Logger(logFile, progName)
{
}

CegoModule::~CegoModule()
{
}

unsigned CegoModule::getModId(const Chain& module)
{
    unsigned i=0;
    while ( i < (unsigned)(sizeof (  CEGO_MODULE_MAP ) / sizeof( char*)) )
    {
	if ( Chain( CEGO_MODULE_MAP[i] ) == module )
	    return i;
	i++;
    }
    throw Exception(EXLOC, Chain("Module ") + module + Chain(" not registered"));
}

Chain CegoModule::getModName(unsigned id)
{
    return Chain( CEGO_MODULE_MAP[id] );
}

unsigned CegoModule::getMapSize()
{
    return sizeof(CEGO_MODULE_MAP) / sizeof(char*);
}
