#ifndef _CEGOQUERY_H_INCLUDED_
#define _CEGOQUERY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQuery.h
// -----------
// Cego query handling
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoQuery
// 
// Description: CegoQuery implements a container class for insert, update and delete queries.
//              This is used for representation of such queries in the native parser but also 
//              inside stored procedures.    
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoQueryManager.h"
#include "CegoPredicate.h"
#include "CegoExpr.h"
#include "CegoAlterDesc.h"
#include "CegoReturnVar.h"
#include "CegoSelect.h"

class CegoDatabaseFormater;

class CegoQuery {
    
public:

    enum QueryMode { INSERT_QUERY, 
		     INSERTBYSELECT_QUERY, 
		     DELETE_QUERY,
		     UPDATE_QUERY,
		     ALTER_QUERY,
		     RENAME_QUERY,
		     START_QUERY,
		     COMMIT_QUERY,
		     ROLLBACK_QUERY,
		     LOCK_QUERY,
		     UNLOCK_QUERY };

    enum TransactionOp { START, COMMIT, ROLLBACK };

    CegoQuery(CegoQueryManager* pGTM, const Chain& tableSet, TransactionOp to);
    CegoQuery(CegoQueryManager* pGTM, const Chain& tableSet,
	      const Chain& tableName,
	      const Chain& tableAlias,
	      CegoPredicate* pPred);
    CegoQuery(CegoQueryManager* pGTM, const Chain& tableSet,
	      const Chain& tableName,
	      const Chain& tableAlias,
	      CegoPredicate* pPred,
	      ListT<CegoField>& updSchema,
	      const ListT<CegoExpr*>& updList,
	      const ListT<CegoReturnVar*> retVarList,
	      bool onFirst);
    CegoQuery(CegoQueryManager* pGTM, const Chain& tableSet,
	      const Chain& tableName,
	      bool doLock);
    CegoQuery(CegoQueryManager* pGTM, const Chain& tableSet,
	      const Chain& tableName,
	      const ListT<CegoField>& schema,
	      const ListT<ListT<CegoExpr*> >& exprListArray);
    CegoQuery(CegoQueryManager* pGTM, const Chain& tableSet,
	      const Chain& tableName,
	      const ListT<CegoField>& schema,
	      CegoSelect* pSelect);

    CegoQuery(CegoQueryManager* pGTM, const Chain& tableSet,
	      const Chain& tableName,
	      const ListT<CegoAlterDesc>& alterList);
    
    CegoQuery(CegoQueryManager* pGTM, const Chain& tableSet,
	      const Chain& objName,
	      CegoObject::ObjectType objType,
	      const Chain& newObjName );    
    ~CegoQuery();

    // void setBlock(CegoProcBlock *pBlock);
    Chain execute(CegoProcBlock* pBlock = 0);
    void cleanUp();
    long getAffectedCount() const;
    Chain toChain(unsigned defTabSetId, const Chain& indent) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
private:

    void prepareFieldValue(CegoField *pFV, CegoFieldValue& fv, unsigned pos);

    QueryMode _mode;
    CegoQueryManager* _pGTM;
    Chain _tableName;
    Chain _tableAlias;
    Chain _objName;
    CegoObject::ObjectType _objType;
    Chain _newObjName;
    Chain _tableSet;
    ListT<CegoField> _schema;
    ListT<CegoExpr*> _updList;
    ListT<ListT<CegoExpr*> > _exprListArray;
    ListT<CegoReturnVar*> _retVarList;
    bool _returnOnFirst;
    ListT<CegoAlterDesc> _alterList; 
    CegoPredicate *_pPred;
    CegoSelect *_pSelect;
    long _affCount;
};
#endif
