///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoReturnVar.cc  
// ----------------
// Cego return variable implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke 
//
// IMPLEMENTATION MODULE
//
// Class: CegoReturnVar
// 
// Description: Procedure return value handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoReturnVar.h"
#include "CegoDatabaseFormater.h"

CegoReturnVar::CegoReturnVar(const Chain& varName,
			     CegoExpr *pExpr)
{
    _varName = varName;
    _pExpr = pExpr;
}

CegoReturnVar::~CegoReturnVar()  
{
}

const Chain& CegoReturnVar::getVarName() const
{
    return _varName;
}

CegoExpr* CegoReturnVar::getExpr() const
{
    return _pExpr;
}

CegoReturnVar& CegoReturnVar::operator = ( const CegoReturnVar& rv)
{
    _varName = rv._varName;
    _pExpr = rv._pExpr;
    return (*this);
}

Chain CegoReturnVar::toChain(unsigned defTabSetId) const
{
    Chain s;
    s = Chain(":")  + _varName + " = " + _pExpr->toChain(defTabSetId);
    return s;
}

Chain CegoReturnVar::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatReturnValue(_varName, _pExpr);
}
