///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoXMLHelper.cc
// ----------------
// Cego XML helper implementation
//     
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoXMLHelper
// 
// Description: Utility class for CegoField to XML mapping
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// xml includes
#include <lfcxml/Element.h>

// cego includes
#include "CegoXMLHelper.h"
#include "CegoTypeConverter.h"
#include "CegoXMLdef.h"

CegoXMLHelper::CegoXMLHelper()
{
}

CegoXMLHelper::~CegoXMLHelper()
{
}

void CegoXMLHelper::setColInfo(Element* pColElement, CegoField *pF )
{
    pColElement->setAttribute(XML_COLNAME_ATTR, pF->getAttrName());
    if ( pF->isNullable() )
	pColElement->setAttribute(XML_COLNULLABLE_ATTR, XML_TRUE_VALUE);
    else
	pColElement->setAttribute(XML_COLNULLABLE_ATTR, XML_FALSE_VALUE);

    if ( pF->getValue().getValue() )
	pColElement->setAttribute(XML_COLDEFVALUE_ATTR, pF->getValue().valAsChain() );
    
    pColElement->setAttribute(XML_COLTYPEID_ATTR, Chain(pF->getType()));
    
    if ( pF->getType() == VARCHAR_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_STRING_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[VARCHAR_TYPE]));
    }
    else if ( pF->getType() == INT_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_INT_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[INT_TYPE]));
    }
    else if ( pF->getType() == LONG_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_LONG_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[LONG_TYPE]));
    }
    else if ( pF->getType() == BOOL_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_BOOL_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[BOOL_TYPE]));
    }
    else if ( pF->getType() == DATETIME_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_DATETIME_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[DATETIME_TYPE]));
    }
    else if ( pF->getType() == BIGINT_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_BIGINT_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[BIGINT_TYPE]));
    }
    else if ( pF->getType() == DECIMAL_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_DECIMAL_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[DECIMAL_TYPE]));
    }
    else if ( pF->getType() == FLOAT_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_FLOAT_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[FLOAT_TYPE]));
    }
    else if ( pF->getType() == DOUBLE_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_DOUBLE_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[DOUBLE_TYPE]));
    }
    else if ( pF->getType() == SMALLINT_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_SMALLINT_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[SMALLINT_TYPE]));
    }
    else if ( pF->getType() == TINYINT_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_TINYINT_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[TINYINT_TYPE]));
    }
    else if ( pF->getType() == BLOB_TYPE )
    {
	pColElement->setAttribute(XML_COLTYPE_ATTR, XML_BLOB_VALUE);
	pColElement->setAttribute(XML_JAVATYPE_ATTR, Chain(CEGO_JAVATYPE_MAP[BLOB_TYPE]));
    }
    
    pColElement->setAttribute(XML_COLSIZE_ATTR, Chain(pF->getLength()));
    pColElement->setAttribute(XML_COLDIM_ATTR, Chain(pF->getDim()));
}

void CegoXMLHelper::getColInfo(const Chain& objName, Element* pColElement, CegoField &f)
{
    Chain colName = pColElement->getAttributeValue(XML_COLNAME_ATTR);
    Chain colType = pColElement->getAttributeValue(XML_COLTYPE_ATTR);
    Chain colSize = pColElement->getAttributeValue(XML_COLSIZE_ATTR);
    Chain colDim = pColElement->getAttributeValue(XML_COLDIM_ATTR);
    Chain colNullable = pColElement->getAttributeValue(XML_COLNULLABLE_ATTR);
    Chain colDefValue = pColElement->getAttributeValue(XML_COLDEFVALUE_ATTR);

    bool isNullable;
    if ( colNullable == Chain(XML_TRUE_VALUE) ) 
	isNullable = true;
    else
	isNullable = false;

    CegoDataType dataType = CegoTypeConverter::getTypeId(colType);
    
    CegoFieldValue defValue;
    if ( colDefValue != Chain() )
    {
	defValue = CegoFieldValue(dataType, colDefValue);
    }
    
    if ( dataType != NULL_TYPE )
	f = CegoField(CegoField(objName, objName, colName, dataType, colSize.asUnsigned(), colDim.asUnsigned(), defValue, isNullable));
    else
	f = CegoField(objName, colName);
}
