#ifndef _CGWRAP_H
#define _CGWRAP_H   1
///////////////////////////////////////////////////////////////////////////////
//                                                         
// cgwrap.h
// --------
// Cego C wrapper API
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// Description: This is a wrapper module which implements a plain C client interface to the
//              cego database system
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifdef  __cplusplus
#include <lfcbase/Logger.h>
#include <lfcbase/NetHandler.h>
#include "CegoDefs.h"
#include "CegoDbHandler.h"
#else
#define PageIdType unsigned long long
#endif

#define CG_INT      1
#define CG_VARCHAR  2
#define CG_LONG     3
#define CG_BOOL     4
#define CG_DATETIME 5
#define CG_BIGINT   6
#define CG_FLOAT    7
#define CG_DOUBLE   8
#define CG_DECIMAL  9
#define CG_SMALLINT 10
#define CG_TINYINT  11
#define CG_BLOB     12
#define CG_CLOB     13
#define CG_NULL     100

#define CG_LOG_ERROR 1
#define CG_LOG_NOTICE 2
#define CG_LOG_DEBUG 3

extern char cgerrmsg[];

typedef struct CegoDBHandle
#ifdef  __cplusplus
{
    CegoModule *pModule;
    Chain host;
    unsigned port;
    NetHandler *pNet;
    CegoDbHandler *pDB;
} 
#endif
CGDB;

typedef struct CegoFetchHandle
#ifdef  __cplusplus
{
    CGDB *cgdb;
    bool isActive;
    ListT<CegoField> *pSchema;
} 
#endif
CGFetch;

typedef struct CegoValue
{
    unsigned type;
    unsigned len;
    void *val;
} CGVal;

typedef struct CegoBlobValue
{
    PageIdType pageId;
    unsigned len;
    unsigned char *buf;
} CGBlob;

typedef struct CegoClobValue
{
    PageIdType pageId;
    unsigned len;
    char *buf;
} CGClob;

typedef struct CegoAttr
{
    unsigned type;
    unsigned len;
    void *name;
} CGAttr;

#ifdef  __cplusplus
class CegoBindValue
{
public:
    
    enum BindType { BINDIN, BINDOUT, BINDINOUT };
    
    unsigned pos;
    CGVal* cgval;
    BindType type;

    CegoBindValue() {}
    CegoBindValue(unsigned p)
    {
	pos = p;
    }
    
    CegoBindValue& operator = ( const CegoBindValue& bv)
    {
	pos = bv.pos;
	cgval = bv.cgval;
        type = bv.type;
	return (*this);
    }
    bool operator == ( const CegoBindValue& bv)
    {
	if ( pos == bv.pos )
	    return true;
	return false;
    }
};
#endif

typedef struct CegoStatement
#ifdef  __cplusplus
{
    unsigned numParams;
    bool isOut;
    ListT<Chain> *pStmtChunks;
    ListT<CegoBindValue> *pParamList;
} 
#endif
CGStmt;

#ifdef  __cplusplus
extern "C" {
#endif

    void cego_modlog(char* module, unsigned level);

    CGDB* cego_connect(char *servername, unsigned portno, char *prot, char *tsname, char *user, char *pass, char* logfile);
    int cego_disconnect (CGDB *cgdb);

    char* cego_server(CGDB* cgdb);
    int cego_port(CGDB* cgdb);
    
    char* cego_protocol(CGDB* cgdb);
    char* cego_dbname(CGDB* cgdb);
    char* cego_version(CGDB* cgdb);
    char* cego_tableset(CGDB* cgdb);
    char* cego_user(CGDB* cgdb);
    
    CGVal* cego_allocate_value(unsigned type, unsigned len, void *val);
    int cego_free_value(CGVal *val);

    CGFetch* cego_allocate_fetch();
    int cego_free_fetch(CGFetch *cgfetch);
    
    int cego_num_col(CGFetch* cgfetch);
    int cego_getpos(CGFetch* cgfetch, char* attr);
    char* cego_getcolname(CGFetch* cgfetch, unsigned pos);
    int cego_getcollen(CGFetch* cgfetch, unsigned pos);
    int cego_getcoltype(CGFetch* cgfetch, unsigned pos);
	 
    CGStmt* cego_prepare (char* stmt);
    int cego_bind_in (CGStmt* cgstmt, CGVal* cgval, unsigned pos);
    int cego_bind_out (CGStmt* cgstmt, CGVal* cgval, unsigned pos);
    int cego_bind_inout (CGStmt* cgstmt, CGVal* cgval, unsigned pos);

    int cego_execute (CGDB *cgdb, CGStmt* cgstmt, CGFetch* cgfetch);

    int cego_free_stmt(CGStmt* cgstmt);
    
    int cego_query (CGDB* cgdb, const char* stmt, CGFetch* cgfetch);
    int cego_isfetchable (CGFetch* cgfetch);
    
    unsigned long cego_getaffected(CGDB* cgdb);
    
    int cego_fetch (CGFetch* cgfetch, CGVal cgval[], unsigned numCol);
    int cego_abort (CGFetch* cgfetch);
    int cego_reset (CGFetch* cgfetch);

    int cego_putblob (CGDB *cgdb, CGBlob* cgblob);
    int cego_getblob (CGDB *cgdb, CGBlob* cgblob);
    int cego_delblob (CGDB *cgdb, CGBlob* cgblob);

    int cego_putclob (CGDB *cgdb, CGClob* cgclob);
    int cego_getclob (CGDB *cgdb, CGClob* cgclob);
    int cego_delclob (CGDB *cgdb, CGClob* cgclob);

    char* cego_error ();
#ifdef  __cplusplus
}
#endif
#endif
