--
-- ### Table alias checks
-- 

drop if exists table t1;
drop if exists table t2;

create table t1 ( a int, b string(30));
create alias a1 on t1 ( a as ax, b as bx );
desc alias a1;

-- drop alias a1;
-- list alias;

-- insert check for alias 
insert into a1 ( ax, bx ) values ( 1, 'XXX');
insert into a1 ( ax, bx ) values ( 2, 'YYY');
insert into a1 ( ax, bx ) values ( 3, 'ZZZ');

create table t2 ( c int, d string(30));
insert into t2 ( c, d ) values ( 2, 'YYY');

desc alias a1;

-- simple select check
select ax  from a1 aa where aa.ax = 1;

-- simple update check
update a1 set bx = 'SIMPLE' where ax = 1;

-- advanced update check with alias reference in nested selected
update a1 set bx = 'T2-MATCH' where ax = ( select c from t2 where t2.d = a1.bx );

-- simple delete check 
delete from a1 where ax = 3;

select * from a1;

--  alias as subset
create alias a2 on t1 ( a as ay );

insert into a2 values ( 4 );

select ay from a2;

-- select ax from a1;

-- select ax from a1;


