///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCheckpoint.cc
// -----------------
// Cego checkpoint class implementation
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoCheckpoint
// 
// Description: 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoCheckpoint.h"

// LFC INCLUDES
#include <lfcbase/Datetime.h>

// POSIX INCLUDES
#include <string.h>
#include <stdlib.h>

CegoCheckpoint::CegoCheckpoint()
{
}

CegoCheckpoint::~CegoCheckpoint()
{
}

bool CegoCheckpoint::checkpointReached(const Chain& tableSet, unsigned interval)
{
    // checkpointing disabled
    if ( interval == 0 )
	return false;

    Datetime ts;
    CheckpointEntry* pCPE;
    if ( ( pCPE = _tsList.Find(CheckpointEntry(tableSet))) != 0 )
    {
	if ( pCPE->getNextCP() < ts.asLong() )
	{
	    // if checkpoint has reached, we set new interval and return true
	    pCPE->setNextCP(ts.asLong() + interval);
	    return true;
	}
	else if ( interval < (unsigned)(pCPE->getNextCP() - ts.asLong()) )
	{
	    // if interval was reduced, we just set new interval
	    pCPE->setNextCP(ts.asLong() + interval);
	    return false;
	}	   
    }
    else
    {
	_tsList.Insert(CheckpointEntry(tableSet, ts.asLong() + interval));
    }
    return false;
}
