#ifndef _CEGODATAPOINTER_H_INCLUDED_
#define _CEGODATAPOINTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDataPointer.h
// -----------------
// Cego Data pointer class definition
//        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDataPointer
// 
// Description: The CegoDataPointer class represents the location of a data entry in any data file.
//              The class provides also encoding and decoding methods to store the pointer information
//              into the database. 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoDefs.h"

class CegoDataPointer {

public:
   
    CegoDataPointer();
    CegoDataPointer(PageIdType pageId, unsigned offset);
    ~CegoDataPointer();

    static unsigned getEncodingLength();

    PageIdType getPageId() const;
    void setPageId(PageIdType pageId);

    unsigned getOffset() const;
    void setOffset(unsigned offset);

    void encode(void* p) const;
    void decode(void* p);

    CegoDataPointer& operator = ( const CegoDataPointer& d);
    bool operator == ( const CegoDataPointer& d) const;
    bool operator != ( const CegoDataPointer& d) const;

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoDataPointer& dp);

private:

    PageIdType _pageId;
    unsigned _offset;
};
#endif
