///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcBlockStmt.cc  
// --------------------
// Cego procedure statement block class implementation
//               
// Design and Implementation by Bjoern Lemke
//                                   
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProBlockStmt
//
// Description: Stored procedure block statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoProcBlockStmt.h"
#include "CegoProcException.h"
#include "CegoDatabaseFormater.h"

CegoProcBlockStmt::CegoProcBlockStmt(CegoProcBlock *pBlock, CegoProcBlock *pParentBlock) : CegoProcStmt(pParentBlock)
{
    _pBlock = pBlock;
}

CegoProcBlockStmt::~CegoProcBlockStmt()  
{
    if ( _pBlock )
	delete _pBlock;
}

void CegoProcBlockStmt::setBlock(CegoProcBlock * pBlock)
{
    _pBlock = pBlock;
}

CegoException CegoProcBlockStmt::execute()
{
    CegoException result;
    result =  _pBlock->execute();
    if ( result != NONE_EXCEP )
	return result;
    
    return NONE_EXCEP;
}

void CegoProcBlockStmt::cleanUp()
{
    _pBlock->cleanUp();
}

Chain CegoProcBlockStmt::toChain(unsigned defTabSetId, const Chain& indent) const
{
    Chain s;
    s = indent + Chain("begin\n");
    s += _pBlock->toChain(defTabSetId, indent + Chain(DEFAULTINDENT));

    CegoProcException **pException = _pBlock->getExceptionList().First();
    while ( pException ) 
    {
	s += indent + Chain("exception when ") + (*pException)->toChain(defTabSetId) + Chain(" then \n");	
	s += (*pException)->getBlock()->toChain(defTabSetId, indent + Chain(DEFAULTINDENT));
	pException = _pBlock->getExceptionList().Next();
    }

    s += indent + Chain("end");
    return s;
}

Chain CegoProcBlockStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcBlockStmt(_pBlock);
}

bool CegoProcBlockStmt::isStatic() const
{
    ListT<CegoProcStmt*> stmtList = _pBlock->getStmtList();
	
    CegoProcStmt **pStmt = stmtList.First();
    while ( pStmt )
    {
	if ( (*pStmt)->isStatic() == false )
	    return false;
	pStmt = stmtList.Next();	
    }
    return true;
}
