#ifndef _CEGOPROCVAR_H_INCLUDED_
#define _CEGOPROCVAR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcVar.h
// -------------
// Cego procedure variable container class
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcVar
// 
// Description: Data structure description for cego procedure parameters
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoFieldValue.h"

class CegoDatabaseFormater;

class CegoProcVar {

public:
    
    enum VarType { INVAR, OUTVAR, BLOCKVAR };

    CegoProcVar();
    CegoProcVar(const Chain& varName);
    CegoProcVar(const Chain& varName, VarType paramType, CegoDataType dt, unsigned dtlen, unsigned dtdim, const CegoFieldValue& fv);
    ~CegoProcVar();
    
    void setName(const Chain& name);
    const Chain& getName() const;
    void setVarType(VarType type);
    VarType getVarType() const;
    CegoDataType getType() const;
    unsigned getLength() const;
    unsigned getDim() const;
    void setValue(const CegoFieldValue& fv);
    const CegoFieldValue& getValue() const;
    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;

    CegoProcVar& operator = ( const CegoProcVar& pp);
    bool operator == ( const CegoProcVar& pp);
    friend ostream& operator << (ostream& s, const CegoProcVar& pp);
    
private:
    
    Chain _name;
    VarType _paramType;
    CegoDataType _dt;
    unsigned _dtlen;
    unsigned _dtdim;
    CegoFieldValue _fv;
};
#endif
