#ifndef _CEGOQUERYMANAGER_H_INCLUDED_
#define _CEGOQUERYMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQueryManager.h
// ------------------
// Cego query manager class definition
// 
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2026 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDistManager
// 
// Description: Query manager for high level data access
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/HashT.h>

#include "CegoField.h"
#include "CegoPredicate.h"
#include "CegoTableManager.h"
#include "CegoLockHandler.h"
#include "CegoDatabaseManager.h"
#include "CegoReplacer.h"

class CegoAction;

class CegoQueryManager : public CegoTableManager {

public:
    
    CegoQueryManager(CegoDatabaseManager *pDBMng);
    ~CegoQueryManager();

    void createTableSet(const Chain& tableSet);

    void registerObjects(const Chain& tableSet);

    void startQueryTableSet(const Chain& tableSet, bool cleanIt, bool cpDump, bool doAutoCorrect, bool doTempReset);    
    void stopQueryTableSet(const Chain& tableSet, bool archComplete);
    
    // bool objectExists( const Chain& tableSet, const Chain& objName, CegoObject::ObjectType objType);
    void getQueryObject(const Chain& tableSet, const Chain& objName, CegoObject::ObjectType type, CegoDecodableObject& oe);
    // void getLocalObject(unsigned tabSetId, const Chain& objName, CegoObject::ObjectType type, CegoDecodableObject& oe);
    
    void createQueryTable(const Chain& tableSet, const Chain& tableName, ListT<CegoField>& fldList, ListT<CegoField>& idxList, bool useColumnId = false);

    void createQueryForeignKey( const Chain& tableSet, const Chain& fkey, const Chain& tableName, const ListT<CegoField>& keyList, const Chain& refTable, const ListT<CegoField>& refList);
    void createQueryCheck( const Chain& tableSet, const Chain& checkName, const Chain& tableName, CegoPredicate *pPredDesc);

    void reorgQueryObject(const Chain& tableSet, const Chain& tableName, CegoObject::ObjectType type);
    void createQueryIndex( const Chain& tableSet, const Chain& indexName, const Chain& tableName, ListT<CegoField>& schema, CegoObject::ObjectType type, bool isCached = false);
    void insertQueryTable(CegoTableObject& oe, ListT<CegoField>& fvl);
    void insertQueryTable(CegoTableObject& oe, ListT< ListT<CegoField> >& fva);

    unsigned long long deleteQueryTable(CegoTableObject& oe, CegoPredicate* pPred, CegoProcBlock* pBlock = 0);

    unsigned long long updateQueryTable(CegoTableObject& oe,
				   CegoPredicate* pPred,
				   ListT<CegoField>& updSchema,
				   ListT<CegoExpr*>& exprList,
				   bool returnOnFirst,
				   ListT<CegoField>& returnList,
				   CegoProcBlock* pBlock = 0);
    void alterQueryTable(CegoTableObject& oe, const ListT<CegoAlterDesc>& alterList);
    void renameQueryObject(const Chain& tableSet, const Chain& objName, CegoObject::ObjectType type,  const Chain& newObjName);

    void createQueryView(const Chain& tableSet, const Chain& viewName, const ListT<CegoField>& schema, const Chain& viewText);
    void createLocalView(unsigned tabSetId, const Chain& viewName, const ListT<CegoField>& schema, const Chain& viewText);

    void createQueryTrigger(const Chain& tableSet, const Chain& triggerName,
			   bool isBefore, bool isOnInsert, bool isOnUpdate, bool isOnDelete,
			   const Chain& tableName, const Chain& triggerText);
    void createQueryAlias(const Chain& tableSet, const Chain& aliasName,
			   const Chain& tableName, const ListT<CegoAttrAlias>& aliasList);
    void createQueryProc(const Chain& tableSet, const Chain& procName, const Chain& procText);

    void truncateQueryTable(const Chain& tableName, const Chain& tableSet);
    void dropQueryObject(const Chain& tableName, const Chain& tableSet, CegoObject::ObjectType type);

    
    void startTransaction( const Chain& tableSet);
    long endTransaction( const Chain& tableSet);
    long rollbackTransaction( const Chain& tableSet);
    unsigned long long getTid( const Chain& tableSet);
    void setAllocatedSortArea(unsigned long long n);
    unsigned long long getAllocatedSortArea() const;
    void syncDistTableSet(const Chain& tableSet, const Chain& msg, const Chain& escCmd, unsigned timeout);
    void enableAuth();
    void disableAuth();
    void setActiveUser(const Chain& tableSet, const Chain& user, const Chain& passwd);
    CegoLockHandler* getLockHandle();
    const Chain& getUser() const;
    void getActiveUser(const Chain& tableSet, Chain& user, Chain& password);
    Element* verifyTable(const Chain& tableSet, const Chain& tableName);
    Element* verifyView(const Chain& tableSet, const Chain& viewName);
    Element* verifyProcedure(const Chain& tableSet, const Chain& procName);
    Element* correctTable(const Chain& tableSet, const Chain& tableName);
    void getObjectDesc(const Chain& tableSet, const Chain& objName, CegoObject::ObjectType type, 
		       ListT<CegoField>& schema, ListT< ListT<CegoFieldValue> > &fa);
    CegoView* getView(unsigned tabSetId, const Chain& viewName);

    
    CegoProcedure* getProcedure(unsigned tabSetId, const Chain& procName);
    CegoTrigger* getTrigger(unsigned tabSetId, const Chain& triggerName);
    CegoAction* getParser();

    void reloadView(unsigned tabSetId, const Chain& viewName);   
    void reloadProcedure(unsigned tabSetId, const Chain& procName);
    void reloadTrigger(unsigned tabSetId, const Chain& triggerName);
    void setGraceMode(bool isGrace);
    bool isGraceMode() const;

    CegoReplacer* getReplacer(const Chain& pattern, const Chain& replace);
    
private:


    bool checkKey(unsigned tabSetId, const Chain& tableName, const ListT<CegoField>& schema, const ListT<CegoKeyObject>& keyList);
    
    class ActiveTSUser {
	
    public:
        
        ActiveTSUser();
        ActiveTSUser(const Chain& tableSet);
        ActiveTSUser (const Chain& tableSet, const Chain& userName, const Chain& passwd );
        ~ActiveTSUser();
	
        const Chain& getUserName() const;
        const Chain& getPasswd() const;

        ActiveTSUser& operator = (const ActiveTSUser& u); 
	bool operator == (const ActiveTSUser& t) const;
        
    private:
        
	Chain _tableSet;
        Chain _userName;
	Chain _passwd;
	
    };

    HashT<CegoReplacer>* _pRepHash;
    ListT<ActiveTSUser> _userList;
    CegoAction* _pPA;
    Chain _authUser;
    bool _authEnabled;
    unsigned long long _numAllocated;
    bool _isGrace;
    unsigned long _modId;
};
#endif
