#ifndef _CEGORECOVERYMANAGER_H_INCLUDED_
#define _CEGORECOVERYMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoRecoveryManager.h
// ---------------------
// Cego recovery manager class definition
// 
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoRecoveryManager
// 
// Description: Transaction recovery handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>

// xml includes
#include <lfcxml/XMLOutStream.h>

// cego includes
#include "CegoDataType.h"
#include "CegoTupleState.h"
#include "CegoField.h"
#include "CegoQueryHelper.h"
#include "CegoLockHandler.h"
#include "CegoTransactionManager.h"
#include "CegoAlterDesc.h"
#include "CegoDefs.h"
#include "CegoProcedure.h"
#include "CegoView.h"
#include "CegoQueryManager.h"
#include "CegoAdminHandler.h"

class CegoRecoveryManager {

public:

    enum RecoveryState { RECPITREACHED, RECOK };

    CegoRecoveryManager(CegoQueryManager *pTabMng);
    ~CegoRecoveryManager();


    unsigned long long startRecovery(const Chain& tableSet);
    
    unsigned long long recoverTableSet(const Chain& tableSet, long long pit, unsigned long long targetlsn, CegoAdminHandler* pAH);
    RecoveryState recoverCurrentTransactionLog(unsigned tabSetId, long long pit, unsigned long long targetlsn, unsigned long long& reachlsn, long long& ts);
    
private:

    unsigned long long dataFileRecovery(const Chain& tableSet, unsigned tabSetId, unsigned long long  lsn, CegoAdminHandler* pAH);
    unsigned long long transactionRecovery(const Chain& tableSet, unsigned tabSetId, unsigned long long cplsn, long long pit, unsigned long long targetlsn, CegoAdminHandler* pAH);
    unsigned long long recoverCurrentDataFileLog(unsigned tabSetId, bool& endOfBackup);
    bool restoreLogFile(const Chain& tableSet, unsigned long lsn);
    
    Logger* _pLogger;
    CegoQueryManager* _pGTM;
    CegoDatabaseManager* _pDBMng;
    Chain _shellCmd;
    SetT<Chain> _invalidatedList;
    unsigned long _modId;
};
#endif
