package de.lemkeit.cegojdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CegoBlob implements Blob 
{
	
	final Logger _logger = LoggerFactory.getLogger(CegoBlob.class);
	
	private InputStream _is;
	private int _len;
	private byte[] _blobBuf;
	
	public CegoBlob()
	{
		_blobBuf = null;
		_is = null;
		_len = 0;
	}
	
	public CegoBlob(InputStream is) throws IOException
	{
		ByteArrayOutputStream buffer = new ByteArrayOutputStream();

		int nRead;
		byte[] data = new byte[Constant.BLOBCHUNKSIZE];

		while ((nRead = is.read(data, 0, data.length)) != -1) 
		{
			buffer.write(data, 0, nRead);
		}

		buffer.flush();

		_blobBuf = buffer.toByteArray();
		_len = _blobBuf.length;
		_is = null;
	}
	
	public CegoBlob(InputStream is, int len)
	{
		_blobBuf = null;
		_is = is;
		_len = len;
	}
	
	
	public CegoBlob(byte[] blobBuf)
	{
		_blobBuf = blobBuf;
		_len = blobBuf.length;
	}

	public void allocate(long blobSize) throws SQLException
	{
		if ( blobSize > Constant.MAXBLOBSIZE )
			throw new SQLException("Blob size exceeded");
		
		_blobBuf = new byte[ (int) blobSize];
		_len = (int)blobSize;
	}
		
	public void free() throws SQLException 
	{
		_blobBuf = null;
		_is = null;
		_len = 0;
	}

	public InputStream getBinaryStream() throws SQLException 
	{
		if ( _is != null)
			return _is;
		if ( _blobBuf != null )
			return new ByteArrayInputStream(_blobBuf, 0, _blobBuf.length);
		throw new SQLException("No stream available");
	}

	public InputStream getBinaryStream(long pos, long length) throws SQLException 
	{
		if ( _is != null)
		{
			throw new SQLException("Inappropriate stream");
		}
		if ( _blobBuf != null )
			return new ByteArrayInputStream(_blobBuf, (int)pos, (int)length);		
		throw new SQLException("No stream available");
	}
	
	public byte[] getBytes(long pos, int length) throws SQLException 
	{
		byte[] byteBuf = new byte[ length - ((int)pos-1)];
		System.arraycopy(_blobBuf, (int)pos-1, byteBuf, 0 , length);
		return byteBuf;
	}
	
	public long length() throws SQLException 
	{
		return _len;
	}

	public long position(byte[] pattern, long start) throws SQLException 
	{
		throw new SQLException("Method not implemented");
	}
	
	public long position(Blob pattern, long start) throws SQLException 
	{
		throw new SQLException("Method not implemented");
	}
	
	public OutputStream setBinaryStream(long pos) throws SQLException 
	{
		return null;
	}
	
	public int setBytes(long pos, byte[] bytes) throws SQLException 
	{
		System.arraycopy(bytes, 0, _blobBuf, (int)pos , bytes.length);
		return bytes.length;
	}
	
	public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException 
	{
		_logger.debug("setBytes pos=" + pos + " offset=" + offset + " len=" + len);
		System.arraycopy(bytes, offset, _blobBuf, (int)pos, len);
		return len;
	}
	
	public void truncate(long blobSize) throws SQLException 
	{
		if ( blobSize > Constant.MAXBLOBSIZE )
			throw new SQLException("Blob size exceeded");
		
		_len = (int)blobSize;
		_blobBuf = new byte[ _len];
	}
}
