package de.lemkeit.cegojdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
// import java.sql.CallableStatement;
import java.sql.Clob;
// import java.sql.DatabaseMetaData;
import java.sql.Date;
// import java.sql.PreparedStatement;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
// import java.sql.Savepoint;
// import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

public class CegoCallableStatement extends CegoPreparedStatement implements java.sql.CallableStatement {

	
	boolean _wasNull = false;
	
	public CegoCallableStatement(CegoNet netDriver, CegoConnection con, boolean storeLocal) 
	{
		super(netDriver, con, storeLocal);
	}

	public void prepareCall(String call) throws SQLException 
	{
		
		call = call.trim();
		if ( call.charAt(0) == '{' && call.charAt(call.length()-1) == '}' )
		{
			String query = call.substring(1, call.length()-1);
			prepareQuery(query);	
		}
		else
		{
			throw new SQLException("Invalid call format");
		}
	}
	

	public void registerOutParameter(int pos, int type) throws SQLException 
	{	
		setParam(pos, new String(":T" + type + "P" + pos ));	
	}


	public void registerOutParameter(int pos, int type, int scale) throws SQLException 
	{	
		setParam(pos, new String(":T" + type + "P" + pos + "S" + scale));	
	}

	public void registerOutParameter(int pos, int type, String typeName) throws SQLException 
	{
		setParam(pos, new String(":T" + type + "P" + pos + "N" + typeName));	
	}

	public void registerOutParameter(String paramName, int type) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void registerOutParameter(String paramName, int type, int scale) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void registerOutParameter(String arg0, int arg1, String arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}
	
	public String getString(int pos) throws SQLException 
	{
		
		_wasNull = false;
		
		CegoDataRow outParam = getOutParamList().get(pos-1);
		if ( outParam != null )
		{
			if ( outParam.getValue(Constant.XML_TYPE_ATTR).equals(Constant.CEGO_NULL_TYPE) )
				_wasNull = true;
			
			return outParam.getValue(Constant.XML_VALUE_ATTR);
		}
		throw new SQLException("No outparam found");
	}

	public boolean getBoolean(int pos) throws SQLException 
	{
		String s = getString(pos); 
		if ( wasNull() )
			return false;
		
		if ( s.equals("true") )
			return true;
		return false;

	}

	public byte getByte(int pos) throws SQLException 
	{
		String s = getString(pos); 
		if ( wasNull() )
			return 0;
		return Byte.valueOf(s).byteValue();
	}

	public short getShort(int pos) throws SQLException 
	{
		String s = getString(pos); 
		if ( wasNull() )
			return 0;
		return Short.valueOf(s).shortValue();
	}

	public int getInt(int pos) throws SQLException 
	{
		
		String s = getString(pos);
		if ( wasNull() )
			return 0;
		return Integer.valueOf(s).intValue();
	}

	public long getLong(int pos) throws SQLException 
	{
		String s = getString(pos);
		if ( wasNull() )
			return 0;
		return Long.valueOf(s).longValue();	
	}

	public float getFloat(int pos) throws SQLException 
	{
		String s = getString(pos);
		if ( wasNull() )
			return 0;
		return Float.valueOf(s).floatValue();	
	}

	public double getDouble(int pos) throws SQLException 
	{
		String s = getString(pos);
		if ( wasNull() )
			return 0;
		return Double.valueOf(s).doubleValue();		
	}

	public BigDecimal getBigDecimal(int pos) throws SQLException 
	{
		String s = getString(pos);
		if ( wasNull() )
			return null;
		return new BigDecimal(s);	
	}

	public BigDecimal getBigDecimal(int pos, int scale) throws SQLException 
	{
		String s = getString(pos);
		if ( wasNull() )
			return null;
		return new BigDecimal(s).setScale(scale);	
	}

	public byte[] getBytes(int pos) throws SQLException 
	{
		String s = getString(pos);
		if ( wasNull() )
			return null;
		return s.getBytes();	
	}

	public Date getDate(int pos) throws SQLException 
	{
		String dateString = getString(pos);
		if ( wasNull () )
			return null;
		
		SimpleDateFormat format = new SimpleDateFormat(CegoNet.getDateTimeFormat());
		java.util.Date d = null;
		try 
		{
			d = format.parse( dateString );
		} 
		catch (ParseException e) 
		{	
			throw new SQLException(e.getMessage());
		}

		return new Date(d.getTime());
	}

	public Time getTime(int pos) throws SQLException 
	{
		String timeString = getString(pos);
		if ( wasNull () )
			return null;

		SimpleDateFormat format = new SimpleDateFormat(CegoNet.getDateTimeFormat());
		java.util.Date d = null;
		try 
		{
			d = format.parse( timeString );
		} 
		catch (ParseException e) 
		{	
			throw new SQLException(e.getMessage());
		}

		return new Time(d.getTime());	
	}

	
	public Timestamp getTimestamp(int pos) throws SQLException 
	{
		String timeStampString = getString(pos);
		if ( wasNull () )
			return null;

		SimpleDateFormat format = new SimpleDateFormat(CegoNet.getDateTimeFormat());
		java.util.Date d = null;
		try 
		{
			d = format.parse( timeStampString );
		} 
		catch (ParseException e) 
		{	
			throw new SQLException(e.getMessage());
		}

		return new Timestamp(d.getTime());	
	}

	public Object getObject(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public Ref getRef(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public Blob getBlob(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public Clob getClob(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public Array getArray(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public Date getDate(int arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public Time getTime(int arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public URL getURL(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setURL(String arg0, URL arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setNull(String arg0, int arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setBoolean(String arg0, boolean arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setByte(String arg0, byte arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setShort(String arg0, short arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}
	
	public void setLong(String arg0, long arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setFloat(String arg0, float arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setDouble(String arg0, double arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setBytes(String arg0, byte[] arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setDate(String arg0, Date arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

		
	public void setTimestamp(String arg0, Timestamp arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setDate(String arg0, Date arg1, Calendar arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setNull(String arg0, int arg1, String arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public String getString(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public boolean getBoolean(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public byte getByte(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public short getShort(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public int getInt(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public long getLong(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public float getFloat(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public double getDouble(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public byte[] getBytes(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Date getDate(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Time getTime(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Timestamp getTimestamp(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Object getObject(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public BigDecimal getBigDecimal(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Ref getRef(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Blob getBlob(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Clob getClob(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Array getArray(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Date getDate(String arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Time getTime(String arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public URL getURL(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setCursorName(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void addBatch(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}
	
	public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}
		
	public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public boolean wasNull() throws SQLException 
	{
		return _wasNull;
	}
	
	public void setInt(String parameterName, int value) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setString(String parameterName, String value) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setObject(String arg0, Object arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setObject(String arg0, Object arg1, int arg2) throws SQLException
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setObject(String arg0, Object arg1, int arg2, int arg3) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Reader getCharacterStream(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Reader getCharacterStream(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Reader getNCharacterStream(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public Reader getNCharacterStream(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public NClob getNClob(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public NClob getNClob(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public String getNString(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public String getNString(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public RowId getRowId(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public RowId getRowId(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public SQLXML getSQLXML(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public SQLXML getSQLXML(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setAsciiStream(String arg0, InputStream arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setBinaryStream(String arg0, InputStream arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException
	{
		throw new SQLException("Binary stream not implemented");	
	}

	
	public void setBlob(String arg0, Blob arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setBlob(String arg0, InputStream arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setBlob(String arg0, InputStream arg1, long arg2) throws SQLException
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setCharacterStream(String arg0, Reader arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setClob(String arg0, Clob arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setClob(String arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setClob(String arg0, Reader arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setNCharacterStream(String arg0, Reader arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setNClob(String arg0, NClob arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setNClob(String arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setNClob(String arg0, Reader arg1, long arg2) throws SQLException
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setNString(String arg0, String arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setRowId(String arg0, RowId arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	
	public void setSQLXML(String arg0, SQLXML arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setTime(String parameterName, Time x) throws SQLException 
	{
		throw new SQLException("Method not implemented");	
	}

	public void setTime(String parameterName, Time x, Calendar cal)	throws SQLException 
	{
		throw new SQLException("Method not implemented");			
	}

	@Override
	public void closeOnCompletion() throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public boolean isCloseOnCompletion() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public <T> T getObject(int parameterIndex, Class<T> type)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <T> T getObject(String parameterName, Class<T> type)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
}
