package de.lemkeit.cegojdbc;

import java.sql.Connection;
// import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.StringTokenizer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CegoDatabaseMetaData implements java.sql.DatabaseMetaData 
{

	CegoNet _netDriver;
	CegoConnection _con;
	
	final static Logger _logger = LoggerFactory.getLogger(CegoDatabaseMetaData.class);

	public CegoDatabaseMetaData(CegoNet netDriver, CegoConnection con)
	{
		_netDriver = netDriver;
		_con = con;
	}
	
	
	public boolean allProceduresAreCallable() throws SQLException 
	{
		return true;
	}

	
	public boolean allTablesAreSelectable() throws SQLException 
	{
		return true;
	}

	
	public String getURL() throws SQLException 
	{
		if ( _netDriver.getProtocol() == Constant.NETMSG_JDOM )
		{
			return Constant.JDBC_PROTOCOL_JDOM + ":" 
			+ _netDriver.getHost() + ":" 
			+ _netDriver.getPort() + ":" 
			+ _netDriver.getTableSet();
		}
		else if ( _netDriver.getProtocol() == Constant.NETMSG_XMLNATIVE )
		{
			return Constant.JDBC_PROTOCOL_NATIVE + ":" 
			+ _netDriver.getHost() + ":" 
			+ _netDriver.getPort() + ":" 
			+ _netDriver.getTableSet();
		}
		else if ( _netDriver.getProtocol() == Constant.NETMSG_SERIAL )
		{
			return Constant.JDBC_PROTOCOL_SERIAL + ":" 
			+ _netDriver.getHost() + ":" 
			+ _netDriver.getPort() + ":" 
			+ _netDriver.getTableSet();
		}
		return null;
		
	}

	
	public String getUserName() throws SQLException 
	{
		return _netDriver.getUser();
	}

	
	public boolean isReadOnly() throws SQLException 
	{
		return false;
	}

	
	public boolean nullsAreSortedHigh() throws SQLException 
	{
		return false;
	}

	
	public boolean nullsAreSortedLow() throws SQLException 
	{
		return false;
	}

	
	public boolean nullsAreSortedAtStart() throws SQLException 
	{
		return false;
	}

	
	public boolean nullsAreSortedAtEnd() throws SQLException 
	{
		return false;
	}

	
	public String getDatabaseProductName() throws SQLException 
	{
		return _netDriver.getDBProdName();
	}

	
	public String getDatabaseProductVersion() throws SQLException 
	{
		return _netDriver.getDBProdVersion();		
	}

	
	public String getDriverName() throws SQLException 
	{
		return Constant.JDBC_DRIVERNAME;
	}

	
	public String getDriverVersion() throws SQLException 
	{
		String major = Integer.valueOf( Constant.JDBC_MAJORVERSION ).toString();
		String minor = Integer.valueOf( Constant.JDBC_MINORVERSION ).toString();
		String patch = Integer.valueOf( Constant.JDBC_PATCHVERSION ).toString();

		String sep = new String(".");
		return new String(major + sep + minor + sep + patch);
	}

	
	public int getDriverMajorVersion() 
	{
		return Constant.JDBC_MAJORVERSION;
	}

	
	public int getDriverMinorVersion() 
	{
		return Constant.JDBC_MINORVERSION;
	}

	
	public boolean usesLocalFiles() throws SQLException 
	{
		return true;
	}

	
	public boolean usesLocalFilePerTable() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsMixedCaseIdentifiers() throws SQLException 
	{
		return true;
	}

	
	public boolean storesUpperCaseIdentifiers() throws SQLException 
	{
		return true;
	}

	
	public boolean storesLowerCaseIdentifiers() throws SQLException 
	{
		return true;
	}

	
	public boolean storesMixedCaseIdentifiers() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException 
	{
		return false;
	}

	
	public boolean storesUpperCaseQuotedIdentifiers() throws SQLException 
	{
		return false;
	}

	
	public boolean storesLowerCaseQuotedIdentifiers() throws SQLException 
	{
		return false;
	}

	
	public boolean storesMixedCaseQuotedIdentifiers() throws SQLException 
	{
		return false;
	}

	
	public String getIdentifierQuoteString() throws SQLException 
	{
		return " ";
	}

	
	public String getSQLKeywords() throws SQLException 
	{	
		return Constant.SQL_KEYWORDS;
	}

	
	public String getNumericFunctions() throws SQLException 
	{
		return Constant.NUMERIC_FUNCTIONS;
	}

	
	public String getStringFunctions() throws SQLException 
	{
		return Constant.STRING_FUNCTIONS;
	}

	
	public String getSystemFunctions() throws SQLException 
	{
		return Constant.SYSTEM_FUNCTIONS;
	}

	
	public String getTimeDateFunctions() throws SQLException 
	{
		return Constant.TIMEDATE_FUNCTIONS;
	}

	
	public String getSearchStringEscape() throws SQLException 
	{	
		return Constant.SEARCH_STRING_ESCAPE;
	}

	
	public String getExtraNameCharacters() throws SQLException 
	{
		return Constant.EXTRA_CHARS;
	}

	
	public boolean supportsAlterTableWithAddColumn() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsAlterTableWithDropColumn() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsColumnAliasing() throws SQLException 
	{
		return false;
	}

	
	public boolean nullPlusNonNullIsNull() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsConvert() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsConvert(int t1, int t2) throws SQLException 
	{
		return false;
	}

	
	public boolean supportsTableCorrelationNames() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsDifferentTableCorrelationNames() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsExpressionsInOrderBy() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsOrderByUnrelated() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsGroupBy() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsGroupByUnrelated() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsGroupByBeyondSelect() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsLikeEscapeClause() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsMultipleResultSets() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsMultipleTransactions() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsNonNullableColumns() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsMinimumSQLGrammar() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsCoreSQLGrammar() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsExtendedSQLGrammar() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsANSI92EntryLevelSQL() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsANSI92IntermediateSQL() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsANSI92FullSQL() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsIntegrityEnhancementFacility() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsOuterJoins() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsFullOuterJoins() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsLimitedOuterJoins() throws SQLException 
	{
		return false;
	}

	
	public String getSchemaTerm() throws SQLException 
	{
		return Constant.SCHEMA_TERM;
	}

	
	public String getProcedureTerm() throws SQLException 
	{
		return Constant.PROC_TERM;
	}

	
	public String getCatalogTerm() throws SQLException 
	{
		return Constant.CATALOG_TERM;
	}

	
	public boolean isCatalogAtStart() throws SQLException 
	{
		return false;
	}

	
	public String getCatalogSeparator() throws SQLException 
	{
		return new String("");
	}

	
	public boolean supportsSchemasInDataManipulation() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsSchemasInProcedureCalls() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsSchemasInTableDefinitions() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsSchemasInIndexDefinitions() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsCatalogsInDataManipulation() throws SQLException 
	{
		return false;
	}
	
	public boolean supportsCatalogsInProcedureCalls() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsCatalogsInTableDefinitions() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsCatalogsInIndexDefinitions() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsPositionedDelete() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsPositionedUpdate() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsSelectForUpdate() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsStoredProcedures() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsSubqueriesInComparisons() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsSubqueriesInExists() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsSubqueriesInIns() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsSubqueriesInQuantifieds() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsCorrelatedSubqueries() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsUnion() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsUnionAll() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsOpenCursorsAcrossCommit() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsOpenCursorsAcrossRollback() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsOpenStatementsAcrossCommit() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsOpenStatementsAcrossRollback() throws SQLException 
	{
		return false;
	}

	
	public int getMaxBinaryLiteralLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxCharLiteralLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxColumnNameLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxColumnsInGroupBy() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxColumnsInIndex() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxColumnsInOrderBy() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxColumnsInSelect() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxColumnsInTable() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxConnections() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxCursorNameLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxIndexLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxSchemaNameLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxProcedureNameLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxCatalogNameLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxRowSize() throws SQLException 
	{
		return 0;
	}

	
	public boolean doesMaxRowSizeIncludeBlobs() throws SQLException 
	{
		return false;
	}

	
	public int getMaxStatementLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxStatements() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxTableNameLength() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxTablesInSelect() throws SQLException 
	{
		return 0;
	}

	
	public int getMaxUserNameLength() throws SQLException 
	{
		return 0;
	}

	
	public int getDefaultTransactionIsolation() throws SQLException 
	{
		return Connection.TRANSACTION_READ_COMMITTED;
	}

	
	public boolean supportsTransactions() throws SQLException 
	{
		return true;
	}

	
	public boolean supportsTransactionIsolationLevel(int level) throws SQLException 
	{
		if ( level == Connection.TRANSACTION_NONE)
			return true;
		if ( level == Connection.TRANSACTION_READ_COMMITTED)
			return true;
		if ( level == Connection.TRANSACTION_READ_UNCOMMITTED)
			return true;
		
		return false;
			
	}

	
	public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException 
	{
		return false;
	}

	
	public boolean supportsDataManipulationTransactionsOnly() throws SQLException 
	{
		return false;
	}

	
	public boolean dataDefinitionCausesTransactionCommit() throws SQLException 
	{
		return false;
	}

	
	public boolean dataDefinitionIgnoredInTransactions() throws SQLException 
	{
		return false;
	}

	
	public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException 
	{
		String ts = null;
		if ( schemaPattern == null )
			ts = _netDriver.getTableSet();
		else
			ts = schemaPattern;
		
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		
		ResultSet rs = s.executeQuery("jdbc proc " + ts);
		s.close();
		
		return rs;
	}

	
	public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNaemPattern, String columnNamePattern) throws SQLException 
	{
		return new CegoResultSet();
	}

	
	public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException 
	{
		String ts = null;
		if ( schemaPattern == null )
			ts = _netDriver.getTableSet();
		else
			ts = schemaPattern;

		CegoResultSet rsTab = null;
		CegoResultSet rsView = null;
		
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		
		for ( String type : types )
		{
			if ( type.equals("TABLE") )
				rsTab = (CegoResultSet)s.executeQuery("jdbc tab " + ts);
			if ( type.equals("VIEW") )
				rsView = (CegoResultSet)s.executeQuery("jdbc vie " + ts);	
		}
		s.close();
		
		if ( rsTab != null && rsView == null)
			return rsTab;
		if ( rsView != null && rsTab == null)
			return rsView;
		
		rsTab.merge(rsView);
		
		// TODO : treat tablename filter
		
		return rsTab;
	}

	
	public ResultSet getSchemas() throws SQLException 
	{
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		ResultSet rs = s.executeQuery("jdbc schema");
		s.close();
		return rs;
	}

	
	public ResultSet getCatalogs() throws SQLException 
	{
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		ResultSet rs = s.executeQuery("jdbc catalog");
		s.close();
		return rs;
	}

	
	public ResultSet getTableTypes() throws SQLException 
	{
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		ResultSet rs = s.executeQuery("jdbc tabletype");
		s.close();
		return rs;
	}

	
	public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException 
	{

		String ts = null;
		if ( schemaPattern == null )
			ts = _netDriver.getTableSet();
		else
			ts = schemaPattern;

		String cmd = "jdbc colinfo " + ts + " " + tableNamePattern;
		
		if ( columnNamePattern != null )
		{
			cmd += " " + columnNamePattern.replaceAll("%", "");
		}

		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		ResultSet rs = s.executeQuery(cmd);
		s.close();
		return rs;

	}

	
	public ResultSet getColumnPrivileges(String arg0, String arg1, String arg2, String arg3) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public ResultSet getTablePrivileges(String arg0, String arg1, String arg2) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public ResultSet getVersionColumns(String arg0, String arg1, String arg2) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
		// return new CegoResultSet();
	}

	
	public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException 
	{
		String ts = null;
		if ( schema == null )
			ts = _netDriver.getTableSet();
		else
			ts = schema;

		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		
		ResultSet rs = s.executeQuery("jdbc pkey " + ts + " " + table);
		s.close();
		return rs;
	}

	
	public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException 
	{
		String ts = null;
		if ( schema == null )
			ts = _netDriver.getTableSet();
		else
			ts = schema;

		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		
		ResultSet rs = s.executeQuery("jdbc ikey " + ts + " " + table);
		s.close();
		return rs;
	}

	
	public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException 
	{
		String ts = null;
		if ( schema == null )
			ts = _netDriver.getTableSet();
		else
			ts = schema;

		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		
		ResultSet rs = s.executeQuery("jdbc ekey " + ts + " " + table);
		s.close();
		return rs;
	}

	
	public ResultSet getCrossReference(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	
	public ResultSet getTypeInfo() throws SQLException 
	{
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		ResultSet rs =  s.executeQuery("jdbc typeinfo");
		s.close();
		return rs;
	}

	
	public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException 
	{
		String ts = null;
		if ( schema == null )
			ts = _netDriver.getTableSet();
		else
			ts = schema;
		String idxString = "idx";
		if ( unique )
			idxString="uidx";
			
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		ResultSet rs = s.executeQuery("jdbc " + idxString + " " + ts + " " + table + " " );
		s.close();
		
		return rs;
		
	}

	
	public boolean supportsResultSetType(int type) throws SQLException 
	{
		if ( type == ResultSet.TYPE_FORWARD_ONLY )
			return true;
		if ( type == ResultSet.TYPE_SCROLL_INSENSITIVE )
			return true;
		return false;
	}

	
	public boolean supportsResultSetConcurrency(int arg0, int arg1) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean ownUpdatesAreVisible(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean ownDeletesAreVisible(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean ownInsertsAreVisible(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean othersUpdatesAreVisible(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean othersDeletesAreVisible(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean othersInsertsAreVisible(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean updatesAreDetected(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean deletesAreDetected(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean insertsAreDetected(int arg0) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public boolean supportsBatchUpdates() throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}

	
	public ResultSet getUDTs(String arg0, String arg1, String arg2, int[] arg3) throws SQLException 
	{
		return new CegoResultSet();	
	}

	
	public Connection getConnection() throws SQLException {
		return _con;
	}

	
	public boolean supportsSavepoints() throws SQLException 
	{
		return false;
	}
	
	public boolean supportsNamedParameters() throws SQLException 
	{
		return true;
	}
		
	public boolean supportsMultipleOpenResults() throws SQLException 
	{
		return false;
	}

	public boolean supportsGetGeneratedKeys() throws SQLException 
	{
		return false;
	}
	
	public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}
	
	public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}
	
	public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}
	
	public boolean supportsResultSetHoldability(int arg0) throws SQLException 
	{
		return false;
	}
	
	public int getResultSetHoldability() throws SQLException 
	{
		throw new SQLException("Result set holdability not supported");		
	}
	
	public int getDatabaseMajorVersion() throws SQLException 
	{
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		ResultSet rs = s.executeQuery("jdbc prodversion");
		s.close();
		
		if ( rs.next() )
		{
			String prodVersion = rs.getString("PROD_VERSION");

			rs.close();

			StringTokenizer tok = new StringTokenizer(prodVersion, ".");
			
			return Integer.valueOf(tok.nextToken() ).intValue();
		}
		throw new SQLException("Cannot get database major version");		
	}
	
	public int getDatabaseMinorVersion() throws SQLException 
	{
		CegoStatement s = new CegoStatement(_netDriver, _con, true);
		ResultSet rs = s.executeQuery("jdbc prodversion");
		s.close();

		if ( rs.next() )
		{
			String prodVersion = rs.getString("PROD_VERSION");

			rs.close();

			StringTokenizer tok = new StringTokenizer(prodVersion, ".");
			tok.nextToken();
			return Integer.valueOf( tok.nextToken() ).intValue();
		}
		throw new SQLException("Cannot get database minor version");		
	}
	
	public int getJDBCMajorVersion() throws SQLException 
	{
		return Constant.JDBC_MAJORVERSION;
	}
	
	public int getJDBCMinorVersion() throws SQLException 
	{
		return Constant.JDBC_MINORVERSION;
	}
	
	public int getSQLStateType() throws SQLException 
	{
		return sqlStateSQL99;
	}
	
	public boolean locatorsUpdateCopy() throws SQLException 
	{
		return false;
	}
	
	public boolean supportsStatementPooling() throws SQLException
	{
		return false;
	}
	
	public boolean autoCommitFailureClosesAllResultSets() throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}
	
	public ResultSet getClientInfoProperties() throws SQLException 
	{
		return null;
	}
	
	public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}
	
	public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}
	
	public RowIdLifetime getRowIdLifetime() throws SQLException 
	{
		return RowIdLifetime.ROWID_UNSUPPORTED;
	}
	
	public ResultSet getSchemas(String arg0, String arg1) throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}
	
	public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException 
	{
		throw new SQLFeatureNotSupportedException("Method not implemented");		
	}
	
	public boolean isWrapperFor(Class<?> iface) throws SQLException 
	{
		return iface.isInstance(this);		
	}
	
	public <T> T unwrap(Class<T> iface) throws SQLException 
	{
		try {
			return iface.cast(this);
		} catch (ClassCastException cce) {
			throw new SQLException("Unable to wrap");
		}		
	}


	@Override
	public ResultSet getPseudoColumns(String catalog, String schemaPattern,
			String tableNamePattern, String columnNamePattern)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public boolean generatedKeyAlwaysReturned() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

}
