package de.lemkeit.cegojdbc;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class CegoDecimal {

	private int _intpart;
	private int _decpart;
	private int _scale;

	public CegoDecimal(String value) throws SQLException
	{
		try
		{
			StringTokenizer tok = new StringTokenizer(value, ".");
			String ip = tok.nextToken();
			String dp = tok.nextToken();

			_intpart = Integer.valueOf(ip).intValue();
			_scale = dp.length();
			_decpart = Integer.valueOf(dp).intValue();
			
		}
		catch ( Exception e )
		{
			throw new SQLException("CegoDecimal format violation");
		}
	}

	
	public CegoDecimal(String value, int scale) throws Exception
	{
		try
		{
			StringTokenizer tok = new StringTokenizer(value, ".");
			String ip = tok.nextToken();
			String dp = tok.nextToken();

			_intpart = Integer.valueOf(ip).intValue();
			_scale = scale;
			
			_decpart = Integer.valueOf(dp.substring(0, scale)).intValue();
			
		}
		catch ( Exception e )
		{
			throw new Exception("CegoDecimal format violation");
		}
	}
	
	public float getFloat()
	{
		return _intpart + _decpart / (int)Math.pow(10, _scale);
	}
	
	@Override
	public String toString()
	{
		String d = Integer.valueOf( _decpart ).toString();
		int i = Integer.valueOf ( _decpart ).toString().length();
		while ( i < _scale )
		{
			d = "0" + d;
			i++;
		}
		return _intpart + "." + d;
	}
	
}
