package de.lemkeit.cegojdbc;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.StringTokenizer;

public class CegoDriver implements java.sql.Driver 
{
		
	static int _protocol = Constant.NETMSG_JDOM;
	static String _charset = Constant.CHARSET;

	static 
	{
		try {
			java.sql.DriverManager.registerDriver(new CegoDriver());
		} catch (SQLException E) {
			throw new RuntimeException("Driver cannot be registered");
		}
	}
	
	
	// URL Format : jdbc:cego:<protocol>:<hostname>:<port>:<tableset>
	
	public Connection connect(String url, Properties p) throws SQLException 
	{
			
		String[] conArray = url.split(":");
		
		String protocol = conArray[2];
		
		if ( protocol.equals(Constant.JDBC_PROTOCOL_JDOM) )
		{
			_protocol = Constant.NETMSG_JDOM;
			// throw new RuntimeException("Invalid protocol");
		}
		else if ( protocol.equals(Constant.JDBC_PROTOCOL_NATIVE) )
		{
			_protocol = Constant.NETMSG_XMLNATIVE;
		}
		else if ( protocol.equals(Constant.JDBC_PROTOCOL_SERIAL) )
		{
			_protocol = Constant.NETMSG_SERIAL;
		}
		else if ( protocol.equals(Constant.JDBC_PROTOCOL_FASTSERIAL) )
		{
			_protocol = Constant.NETMSG_FASTSERIAL;
		}
		else
		{
			throw new SQLException("Invalid protocol");
		}
		
		String hostname = conArray[3];
		int port = Integer.parseInt(conArray[4]);
		String tablesetInfo = conArray[5];

		StringTokenizer tok = new StringTokenizer(tablesetInfo, "&");
		
		String tableset = tok.nextToken();
		
		while ( tok.hasMoreTokens())
		{
			String attrInfo = tok.nextToken();
			StringTokenizer attrTok = new StringTokenizer(attrInfo, "=");
			String attrName = attrTok.nextToken();
			String attrValue = attrTok.nextToken();
			if ( attrName.equals("characterEncoding"))
			{
				_charset = attrValue;
			}
		}
		CegoNet netDriver = new CegoNet(hostname, port, _protocol, _charset);
				
		try 
		{
			netDriver.requestSession(tableset, p.get("user").toString(), p.get("password").toString());
		} 
		catch (Exception e) 
		{	
			e.printStackTrace();
			throw new SQLException( e );	
		}
		
		Connection con = new CegoConnection(netDriver);
		return con;
	}
	
	
	public boolean acceptsURL(String url) throws SQLException 
	{

		String[] conArray = url.split(":");
		
		if ( conArray.length != 6 )
			return false;
		
		String protocol = conArray[2];
		
		if ( ! protocol.equals(Constant.JDBC_PROTOCOL_JDOM) 
				&& ! protocol.equals(Constant.JDBC_PROTOCOL_NATIVE)
				&& ! protocol.equals(Constant.JDBC_PROTOCOL_SERIAL)
				&& ! protocol.equals(Constant.JDBC_PROTOCOL_FASTSERIAL)
				)
		{
			return false;
		}
		
		// String hostname = conArray[3];
		
		try 
		{
			Integer.parseInt(conArray[4]);
		}
		catch ( NumberFormatException e)
		{
			return false;
		}
		
		// String tableset = conArray[5];

		return true;
	}

	
	public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException 
	{
		return null;
	}

	
	public int getMajorVersion() 
	{
		return Constant.JDBC_MAJORVERSION;
	}

	
	public int getMinorVersion() 
	{
		return Constant.JDBC_MINORVERSION;
	}

	
	public boolean jdbcCompliant() 
	{
		// still we are not compliant
		return false;
	}


	@Override
	public java.util.logging.Logger getParentLogger()
			throws SQLFeatureNotSupportedException {
		// TODO Auto-generated method stub
		return null;
	}
}
