package de.lemkeit.cegojdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.jdom2.Element;

public class CegoResultSet implements java.sql.ResultSet 
{
	
	private static final Logger _logger = LoggerFactory.getLogger(CegoResultSet.class);
		
	Element _element = null;
	int _index = -1;
	int _numRows = 0;
	String[]  _schema = null;
	boolean _wasNull = false;
	CegoNet _netDriver = null;
	boolean _rowsAvailable;
	List<CegoDataRow> _rowList = null;
	int _rowPos = 0;
	int _cursorPos = 0;
	boolean _endOfCom;
	boolean _firstRow = false;
	
	int _resultSetType;
	
	CegoNetMsg _localDG = null;
	
	CegoResultSetMetaData _metaData = null;
	
	public CegoResultSet()
	{
		List<CegoField> fl = new LinkedList<CegoField>();
		_metaData = new CegoResultSetMetaData(fl);
	}
	
	public CegoResultSet(List<CegoField> schema)
	{
		_metaData = new CegoResultSetMetaData(schema);
	}
	
	public CegoResultSet(CegoNet netDriver, List<CegoField> schema,  List<CegoDataRow> rowList)
	{
		_netDriver = netDriver;
		_metaData = new CegoResultSetMetaData(schema);
		if ( rowList != null)
		{				
			_rowsAvailable = true;
			_rowList = rowList;
			_firstRow = true;
		}
		else
		{
			_rowsAvailable = false;
		}
			
		_endOfCom = false;

	}

	public CegoResultSet(CegoNet netDriver, CegoNetMsg dg, List<CegoField> schema)
	{
		_netDriver = netDriver;
		_metaData = new CegoResultSetMetaData(schema);
		_localDG = dg;
		_endOfCom = false;
	}
	
	public List<CegoDataRow> getRowList()
	{
		if ( _localDG != null )
			return _localDG.getRowList();
		return _rowList;
	}
	
	// for internal purposes only
	public void merge(CegoResultSet rs) throws SQLException 
	{
		// check schema here
		if ( _metaData.equals(rs.getMetaData()) == false )
			throw new SQLException("Metadata mismatch");
		
		if ( _localDG != null )
			_rowList = _localDG.getRowList();
		
		
		for ( CegoDataRow r : rs.getRowList() )
		{
			_rowList.add(r);
		}
	}
		
		
	public boolean next() throws SQLException 
	{
		try
		{
			_cursorPos++;

			if ( _localDG == null )
			{
				
				_logger.debug("Retrieving next row from result set ...");

				if ( _netDriver == null || _endOfCom == true )
				{
					return false;
				}
				if ( _rowsAvailable == false  || ( _rowList != null && _rowPos + 1 == _rowList.size()) && _firstRow == false)
				{

					// System.out.println("Rreq next data " + _rowPos + " " + _rowList.size());
					CegoNetMsg dataDoc = _netDriver.reqData();

					if ( dataDoc.getName().equals(Constant.DG_DATA))
					{

						// Element rootElement = dataDoc.getRootElement();

						// System.out.println("Getting rowlist at " + _cursorPos);
						
						_rowList = dataDoc.getRowList(); // rootElement.getChildren(Constant.XML_ROW_ELEMENT);

						// System.out.println("RowList size = "+ + _rowList.size());
						
						_logger.debug("Rowlist size is  " + _rowList.size());

						_rowPos=0;

						_rowsAvailable = true;

						return true;
					}
					else if ( dataDoc.getName().equals(Constant.DG_OK))
					{

						_logger.debug("End of rows reached");

						_endOfCom = true;
						_cursorPos=0;

						return false;
					}
					else if ( dataDoc.getName().equals(Constant.DG_ERROR))	
					{
						_endOfCom = true;

						throw new Exception(dataDoc.getMsg());				
					}

					throw new Exception("Invalid doc type");				
				}
				else
				{
					if ( _firstRow == true)
						_firstRow = false;
					else
						_rowPos++;			
	
					_logger.debug("Row pos = " + _rowPos);
					
					return true;	
				}
			}
			else
			{

				if (  _rowList == null)
				{

					_logger.debug("Setting up rowlist for local doc ...");

					// Element rootElement = _localDoc.getRootElement();

					_rowList = _localDG.getRowList(); //  rootElement.getChildren(Constant.XML_ROW_ELEMENT);
					_rowPos=0;

					_logger.debug("Rowlist is setup with " + _rowList.size() + " rows");

					if ( _rowList.size() > 0 )
						return true;
					return false;
				}
				else if ( _rowPos < _rowList.size()-1)
				{
					_rowPos++;
					_logger.debug("Next row catched -> " + _rowPos);	
					return true;	
				}
				else
				{
					_rowsAvailable = false;
					_cursorPos=0;

					return false;
				}
			}
		}
		catch ( Exception e)
		{
			e.printStackTrace();
			throw new SQLException(e);
		}
	}

	public void close() throws SQLException 
	{		
		try
		{
			// if not localDG and not endOfCom, we have to abort 
			if ( _netDriver != null && _endOfCom == false && _localDG == null)
			{
				_netDriver.abort();
				_endOfCom = true;
			}
		}
		catch ( Exception e )
		{
			throw new SQLException(e);
		}
	}
	
	public boolean wasNull() throws SQLException 
	{
		return _wasNull;
	}

	public String getString(int i) throws SQLException 
	{
		_wasNull = true;
		
		if ( _rowList == null )
			throw new SQLException("No rows available");
		
		if ( _rowList.size() == 0 )
			throw new SQLException("No rows available");
		
		CegoDataRow dataRow = _rowList.get(_rowPos);

		if ( dataRow != null )
		{

			// serial and fastserial mode
			if ( dataRow.hasRowArray() )
			{
				try
				{
					String val = dataRow.getValueAsString(i);
					if ( val == null)
					{
						return null;
					}
					_wasNull = false;
					return val;
				}
				catch ( Exception e )
				{
					e.printStackTrace();
					throw new SQLException(e.getMessage());
				}
			}
			else
			{
				String colName = new String("c" + i);  

				if ( dataRow.getValue(colName) == null )
				{
					return null;
				}

				_wasNull = false;

				String colValue = dataRow.getValue(colName)
						.replaceAll(Constant.XML_NEWLINE, "\n")
						.replaceAll(Constant.XML_TAB, "\t");

				_logger.debug("Returning " + colValue);	

				return colValue;
			}			
		}
		return null;	
	}

	public boolean getBoolean(int i) throws SQLException 
	{
		String s = getString(i); 
		if ( wasNull() )
			return false;
		
		if ( s.equals("true") )
			return true;
		return false;
	}

	public byte getByte(int i) throws SQLException 
	{
		String s = getString(i); 
		if ( wasNull() )
			return 0;
		
		return Byte.valueOf(s).byteValue();
	}

	public short getShort(int i) throws SQLException 
	{
		String s = getString(i); 
		if ( wasNull() )
			return 0;
		return Short.valueOf(s).shortValue();
	}

	public int getInt(int i) throws SQLException 
	{
		_wasNull = true;
		
		if ( _rowList == null )
			throw new SQLException("No rows available");
		
		if ( _rowList.size() == 0 )
			throw new SQLException("No rows available");
			
		CegoDataRow dataRow = _rowList.get(_rowPos);

		if ( dataRow != null )
		{
			// serial and fastserial mode
			if ( dataRow.hasRowArray() )
			{
				try
				{
					Integer val = dataRow.getValueAsInteger(i);
					if ( val == null)
					{
						return 0;
					}
					_wasNull = false;

					_logger.debug("Row Array Returning " + val);	

					return val;
				}
				catch ( Exception e )
				{
					e.printStackTrace();
					throw new SQLException(e);
				}
			}
			else
			{
				String colName = new String("c" + i);  

				if ( dataRow.getValue(colName) == null )
				{
					return 0;
				}

				_wasNull = false;

				String colValue = dataRow.getValue(colName)
						.replaceAll(Constant.XML_NEWLINE, "\n")
						.replaceAll(Constant.XML_TAB, "\t");

				_logger.debug("Returning " + colValue);	

				if ( wasNull () )
					return 0;
				
				
				return Integer.valueOf(colValue).intValue();

			}			
		}
		return 0;
				
	}

	public long getLong(int i) throws SQLException 
	{
		_wasNull = true;
		
		if ( _rowList == null )
			throw new SQLException("No rows available");
		
		if ( _rowList.size() == 0 )
			throw new SQLException("No rows available");
		
		CegoDataRow dataRow = _rowList.get(_rowPos);

		if ( dataRow != null )
		{
			// serial and fastserial mode
			if ( dataRow.hasRowArray() )
			{
				try
				{
					Long val = dataRow.getValueAsLong(i);
					if ( val == null)
					{
						return 0;
					}
					_wasNull = false;
					return val;
				}
				catch ( Exception e )
				{
					throw new SQLException(e);
				}
			}
			else
			{
				String colName = new String("c" + i);  

				if ( dataRow.getValue(colName) == null )
				{
					return 0;
				}

				_wasNull = false;

				String colValue = dataRow.getValue(colName)
						.replaceAll(Constant.XML_NEWLINE, "\n")
						.replaceAll(Constant.XML_TAB, "\t");

				_logger.debug("Returning " + colValue);	

				if ( wasNull () )
					return 0;
				
				
				return Long.valueOf(colValue).longValue();

			}			
		}
		return 0;
				
	}

	public float getFloat(int i) throws SQLException 
	{
		String s = getString(i);
		if ( wasNull() )
			return 0;
		return Float.valueOf(s).floatValue();
	}

	public double getDouble(int i) throws SQLException 
	{
		String s = getString(i);
		if ( wasNull() )
			return 0;
		return Double.valueOf(s).doubleValue();
	}

	public BigDecimal getBigDecimal(int i, int scale) throws SQLException 
	{
		String s = getString(i);
		if ( wasNull() )
			return null;
		return new BigDecimal(s).setScale(scale);
	}

	public byte[] getBytes(int i) throws SQLException 
	{
		String s = getString(i);
		if ( wasNull() )
			return null;
		return s.getBytes();
	}

	public Date getDate(int i) throws SQLException 
	{
		_wasNull = true;
		
		if ( _rowList == null )
			throw new SQLException("No rows available");
		
		if ( _rowList.size() == 0 )
			throw new SQLException("No rows available");
		
		CegoDataRow dataRow = _rowList.get(_rowPos);

		if ( dataRow != null )
		{
			// serial and fastserial mode
			if ( dataRow.hasRowArray() )
			{
				try
				{
					Date val = dataRow.getValueAsDate(i);
					if ( val == null)
					{
						return null;
					}
					_wasNull = false;
					return val;
				}
				catch ( Exception e )
				{
					throw new SQLException(e);
				}
			}
			else
			{
				String colName = new String("c" + i);  

				if ( dataRow.getValue(colName) == null )
				{
					return null;
				}

				_wasNull = false;

				String colValue = dataRow.getValue(colName)
						.replaceAll(Constant.XML_NEWLINE, "\n")
						.replaceAll(Constant.XML_TAB, "\t");

				_logger.debug("Returning " + colValue);	

				if ( wasNull () )
					return null;
				
				SimpleDateFormat format = new SimpleDateFormat(CegoNet.getDateTimeFormat());
				java.util.Date d = null;
				try 
				{
					d = format.parse( colValue );
				} 
				catch (ParseException e) 
				{	
					throw new SQLException(e);
				}
				
				return new Date(d.getTime());

			}			
		}
		return null;	
		
			
	}
	
	public Time getTime(int i) throws SQLException 
	{
		// date also keeps time information
		return new Time(getDate(i).getTime());
		
		/*
		String timeString = getString(i);
		if ( wasNull () )
			return null;

		SimpleDateFormat format = new SimpleDateFormat(CegoNet.getDateTimeFormat());
		java.util.Date d = null;
		try 
		{
			d = format.parse( timeString );
		} 
		catch (ParseException e) 
		{	
			throw new SQLException(e.getMessage());
		}

		return new Time(d.getTime());
		// return Time.valueOf(getString(i));
		 
		 */
	}

	public Timestamp getTimestamp(int i) throws SQLException 
	{
		return new Timestamp(getDate(i).getTime());
		
		/*
		 * 
		 
		String timeStampString = getString(i);
		if ( wasNull () )
			return null;

		SimpleDateFormat format = new SimpleDateFormat(CegoNet.getDateTimeFormat());
		java.util.Date d = null;
		try 
		{
			d = format.parse( timeStampString );
		} 
		catch (ParseException e) 
		{	
			throw new SQLException(e.getMessage());
		}

		return new Timestamp(d.getTime());
		// return Timestamp.valueOf(getString(i));
		 * 
		 */
	}

	
	public BigDecimal getBigDecimal(int i) throws SQLException 
	{
		String s = getString(i);
		if ( wasNull() )
			return null;
		return new BigDecimal( s );
	}

	public InputStream getAsciiStream(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
		
	public InputStream getUnicodeStream(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
		
	public InputStream getBinaryStream(int i) throws SQLException 
	{
		
		String blobRef = getString(i);
		_logger.debug("Retrieving blob " + blobRef);

		if ( wasNull() )
			return null;
		
		StringTokenizer tok = new StringTokenizer(blobRef, "[]");
		long pageId = Integer.valueOf( tok.nextToken() ).intValue();
				
		try {
		
			CegoNet nd = _netDriver.fork();
			InputStream is = nd.getBlob(pageId).getBinaryStream();
			nd.closeSession();
			return is;
		}
		catch (Exception e) 
		{
			throw new SQLException("Cannot get blob : " + e.getMessage());
		}		
	}

	public Blob getBlob(int i) throws SQLException 
	{
		String blobRef = getString(i);
		if ( wasNull() )
			return null;

		StringTokenizer tok = new StringTokenizer(blobRef, "[]");
		long pageId = Integer.valueOf( tok.nextToken() ).intValue();
			
		CegoNet nd = null;
		
		try 
		{
			nd = _netDriver.fork();
			Blob b = nd.getBlob(pageId);
			return b;
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new SQLException("Cannot get blob : " + e.getMessage());
		}		
		finally 
		{
			if ( nd != null )
			{
				try
				{
					nd.closeSession();
				}
				catch ( Exception e)
				{
					throw new SQLException(e);
				}				
			}
		}
	}
	
	public String getString(String col) throws SQLException 
	{
		return getString( _metaData.getColumnPos(col) );
	}

	public boolean getBoolean(String col) throws SQLException 
	{
		return getBoolean( _metaData.getColumnPos(col) );
	}
	
	public byte getByte(String col) throws SQLException 
	{
		return getByte( _metaData.getColumnPos(col) );
	}
	
	public short getShort(String col) throws SQLException 
	{
		return getShort( _metaData.getColumnPos(col) );
	}
		
	public int getInt(String col) throws SQLException 
	{
		return getInt( _metaData.getColumnPos(col) );
	}

	public long getLong(String col) throws SQLException 
	{
		return getLong( _metaData.getColumnPos(col) );
	}
	
	public float getFloat(String col) throws SQLException 
	{
		return getFloat( _metaData.getColumnPos(col) );
	}
		
	public double getDouble(String col) throws SQLException 
	{
		return getDouble( _metaData.getColumnPos(col) );
	}
	
	public BigDecimal getBigDecimal(String col, int scale) throws SQLException 
	{
		return getBigDecimal( _metaData.getColumnPos(col), scale );
	}
	
	public byte[] getBytes(String col) throws SQLException 
	{
		return getBytes( _metaData.getColumnPos(col) );
	}
	
	public Date getDate(String col) throws SQLException 
	{
		return getDate( _metaData.getColumnPos(col) );
	}
	
	public Time getTime(String col) throws SQLException 
	{
		return getTime( _metaData.getColumnPos(col) );
	}
	
	public Timestamp getTimestamp(String col) throws SQLException 
	{
		return getTimestamp( _metaData.getColumnPos(col) );
	}

	public BigDecimal getBigDecimal(String col) throws SQLException 
	{
		return getBigDecimal( _metaData.getColumnPos(col) );
	}
	
	public InputStream getAsciiStream(String col) throws SQLException 
	{
		return getAsciiStream( _metaData.getColumnPos(col) );
	}
	
	public InputStream getUnicodeStream(String col) throws SQLException 
	{
		return getUnicodeStream( _metaData.getColumnPos(col) );
	}
			
	public InputStream getBinaryStream(String col) throws SQLException 
	{
		return getBinaryStream( _metaData.getColumnPos(col) );
	}

	public SQLWarning getWarnings() throws SQLException 
	{
		return null;
	}
	
	public void clearWarnings() throws SQLException 
	{
		return;
	}
	
	public String getCursorName() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public ResultSetMetaData getMetaData() throws SQLException 
	{
		return _metaData;
	}
	
	public Object getObject(int i) throws SQLException 
	{
		if ( _metaData.getColumnTypeName(i).equals(Constant.CEGO_INT_TYPE))
			return getInt(i);
		if ( _metaData.getColumnTypeName(i).equals(Constant.CEGO_STRING_TYPE))
			return getString(i);
		if ( _metaData.getColumnTypeName(i).equals(Constant.CEGO_SMALLINT_TYPE))
			return getShort(i);
		if ( _metaData.getColumnTypeName(i).equals(Constant.CEGO_LONG_TYPE))
			return getLong(i);
		if ( _metaData.getColumnTypeName(i).equals(Constant.CEGO_FLOAT_TYPE))
			return getFloat(i);
		if ( _metaData.getColumnTypeName(i).equals(Constant.CEGO_DOUBLE_TYPE))
			return getDouble(i);
		if ( _metaData.getColumnTypeName(i).equals(Constant.CEGO_DATETIME_TYPE))
			return getDate(i);
		if ( _metaData.getColumnTypeName(i).equals(Constant.CEGO_DECIMAL_TYPE))
		{
			String s = getString(i);
			if ( wasNull() )
				return null;
			return new CegoDecimal(s);
		}
		return null;
	}
	
	public Object getObject(String col) throws SQLException 
	{
		return getObject( _metaData.getColumnPos(col) );
	}
	
	public int findColumn(String col) throws SQLException 
	{
		 return _metaData.getColumnPos(col);		
	}
		
	public Reader getCharacterStream(int i) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Reader getCharacterStream(String col) throws SQLException 
	{
		return getCharacterStream( _metaData.getColumnPos(col) );
	}

	public boolean isBeforeFirst() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public boolean isAfterLast() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public boolean isFirst() throws SQLException 
	{
		if ( _cursorPos == 0)
			return true;
		return false;		
	}
	
	public boolean isLast() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void beforeFirst() throws SQLException 
	{
		try
		{
			_netDriver.reset();
			_rowsAvailable = false;
		}
		catch ( Exception e)
		{
			throw new SQLException(e);
		}
	}
	
	public void afterLast() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public boolean first() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public boolean last() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public int getRow() throws SQLException 
	{
		return _cursorPos;
	}
	
	public boolean absolute(int row) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public boolean relative(int rows) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public boolean previous() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void setFetchDirection(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public int getFetchDirection() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void setFetchSize(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public int getFetchSize() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public int getType() throws SQLException 
	{
		return _resultSetType;
	}
	
	public int getConcurrency() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public boolean rowUpdated() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
		
	public boolean rowInserted() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public boolean rowDeleted() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void updateNull(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBoolean(int arg0, boolean arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateByte(int arg0, byte arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateShort(int arg0, short arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateInt(int arg0, int arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateLong(int arg0, long arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateFloat(int arg0, float arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateDouble(int arg0, double arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateString(int arg0, String arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBytes(int arg0, byte[] arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateDate(int arg0, Date arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateTime(int arg0, Time arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
		
	public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void updateObject(int arg0, Object arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateObject(int arg0, Object arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNull(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
		
	public void updateBoolean(String arg0, boolean arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void updateByte(String arg0, byte arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateShort(String arg0, short arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateInt(String arg0, int arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateLong(String arg0, long arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateFloat(String arg0, float arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateDouble(String arg0, double arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateString(String arg0, String arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void updateBytes(String arg0, byte[] arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateDate(String arg0, Date arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateTime(String arg0, Time arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateObject(String arg0, Object arg1, int arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateObject(String arg0, Object arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
		
	public void insertRow() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void updateRow() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void deleteRow() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void refreshRow() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void cancelRowUpdates() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void moveToInsertRow() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void moveToCurrentRow() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public Statement getStatement() throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Ref getRef(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Clob getClob(int i) throws SQLException 
	{
		String clobRef = getString(i);
		if ( wasNull() )
			return null;

		StringTokenizer tok = new StringTokenizer(clobRef, "[]");
		long pageId = Integer.valueOf( tok.nextToken() ).intValue();
			
		CegoNet nd = null;
		
		try 
		{
			nd = _netDriver.fork();
			Clob c = nd.getClob(pageId);
			return c;
		}
		catch (Exception e) 
		{
			throw new SQLException("Cannot get clob : " + e.getMessage());
		}		
		finally 
		{
			if ( nd != null )
			{
				try
				{
					nd.closeSession();
				}
				catch ( Exception e)
				{
					throw new SQLException(e);
				}				
			}
		}
	}

	public Array getArray(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Ref getRef(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Blob getBlob(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Clob getClob(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Array getArray(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Date getDate(int arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Date getDate(String arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public Time getTime(int arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Time getTime(String arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public URL getURL(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public URL getURL(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateRef(int arg0, Ref arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateRef(String arg0, Ref arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBlob(int arg0, Blob arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void updateBlob(String arg0, Blob arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateClob(int arg0, Clob arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateClob(String arg0, Clob arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateArray(int arg0, Array arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateArray(String arg0, Array arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public int getHoldability() throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Reader getNCharacterStream(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Reader getNCharacterStream(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public NClob getNClob(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public NClob getNClob(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public String getNString(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public String getNString(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Object getObject(int i, Map<String, Class<?>> map) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public RowId getRowId(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public RowId getRowId(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public SQLXML getSQLXML(int arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public SQLXML getSQLXML(String arg0) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public boolean isClosed() throws SQLException 
	{
		return false;
	}

	public void updateAsciiStream(int arg0, InputStream arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateAsciiStream(String arg0, InputStream arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBinaryStream(int arg0, InputStream arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBinaryStream(String arg0, InputStream arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBlob(int arg0, InputStream arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBlob(String arg0, InputStream arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBlob(int arg0, InputStream arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateBlob(String arg0, InputStream arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateCharacterStream(int arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateCharacterStream(String arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateCharacterStream(int arg0, Reader arg1, long arg2)	throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateClob(int arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateClob(String arg0, Reader arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateClob(int arg0, Reader arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateClob(String arg0, Reader arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNClob(int arg0, NClob arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNClob(String arg0, NClob arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNClob(int arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNClob(String arg0, Reader arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateNString(int arg0, String arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}

	public void updateNString(String arg0, String arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateRowId(int arg0, RowId arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateRowId(String arg0, RowId arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException
	{
		throw new SQLException("Method not implemented");		
	}
	
	public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException 
	{
		throw new SQLException("Method not implemented");		
	}
	
	public boolean isWrapperFor(Class<?> iface) throws SQLException
	{
		return iface.isInstance(this);		
	}

	public <T> T unwrap(Class<T> iface) throws SQLException
	{
		try {
			return iface.cast(this);
		} catch (ClassCastException cce) {
			throw new SQLException("Unable to wrap");
		}	
	}

	@Override
	public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public <T> T getObject(String columnLabel, Class<T> type)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}
}
