package de.lemkeit.cegojdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class CegoResultSetMetaData implements java.sql.ResultSetMetaData {

	private List<CegoField> _colList;
	
	public CegoResultSetMetaData(List<CegoField> colList)
	{
		_colList = colList;	
	}
	
	public List<CegoField> getColumnList()
	{
		return _colList;
	}
	
	public int getColumnCount() throws SQLException {
		
		return _colList.size();
	}
	
	
	public boolean isAutoIncrement(int i) throws SQLException 
	{
		// cego supports column independent counter objects for autoincrement
		return false;
	}
	
	public boolean isCaseSensitive(int i) throws SQLException 
	{
		return false;		
	}
	
	public boolean isSearchable(int i) throws SQLException 
	{
		// just blob type are not searchable
		if ( getColumnTypeName(i) == Constant.CEGO_BLOB_TYPE)
			return false;
		return true;
	}
	
	public boolean isCurrency(int i) throws SQLException
	{
		if ( getColumnTypeName(i) == Constant.CEGO_DECIMAL_TYPE)
			return true;
		return false;
	}

	public int isNullable(int i) throws SQLException 
	{
		return ResultSetMetaData.columnNullableUnknown;
	}
	
	public boolean isSigned(int i) throws SQLException
	{
		if ( getColumnTypeName(i) == Constant.CEGO_INT_TYPE)
			return true;
		if ( getColumnTypeName(i) == Constant.CEGO_LONG_TYPE)
			return true;
		if ( getColumnTypeName(i) == Constant.CEGO_SMALLINT_TYPE)
			return true;
		if ( getColumnTypeName(i) == Constant.CEGO_TINYINT_TYPE)
			return true;		
		return false;
	}
	
	public int getColumnDisplaySize(int arg0) throws SQLException
	{
		return 0;		
	}
	
	public String getColumnLabel(int i) throws SQLException
	{	
		return _colList.get(i-1).getColName();
	}

	public int getColumnPos(String col) throws SQLException 
	{	
		int pos = _colList.indexOf(new CegoField(col)) + 1;
		if ( pos == 0)
			throw new SQLException("Unknown column " + col);
		return pos;
	}

	public String getColumnName(int i) throws SQLException 
	{	
		return _colList.get(i-1).getColName();
	}
	
	public String getSchemaName(int i) throws SQLException 
	{
		return "";
	}
	
	public int getPrecision(int i) throws SQLException 
	{
		return 0;	
	}
	
	public int getScale(int i) throws SQLException 
	{
		return 0;
	}
	
	public String getTableName(int i) throws SQLException 
	{
		return "";		
	}
	
	public String getCatalogName(int arg0) throws SQLException 
	{
		return "";		
	}
	
	public int getColumnType(int i) throws SQLException 
	{
		return _colList.get(i-1).getJavaType();
	}
	
	public String getColumnTypeName(int i) throws SQLException 
	{
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_INT_TYPE_ID )
			return new String("int");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_VARCHAR_TYPE_ID )
			return new String("string");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_FLOAT_TYPE_ID )
			return new String("float");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_DOUBLE_TYPE_ID )
			return new String("double");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_DECIMAL_TYPE_ID )
			return new String("bigint");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_LONG_TYPE_ID )
			return new String("long");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_SMALLINT_TYPE_ID )
			return new String("short");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_TINYINT_TYPE_ID )
			return new String("char");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_BLOB_TYPE_ID )
			return new String("blob");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_CLOB_TYPE_ID )
			return new String("clob");
		return null;
	}
	
	public boolean isReadOnly(int arg0) throws SQLException 
	{
		return true;
	}
	
	public boolean isWritable(int arg0) throws SQLException 
	{
		return false;	
	}
	
	public boolean isDefinitelyWritable(int arg0) throws SQLException 
	{
		return false;		
	}
	
	public String getColumnClassName(int i) throws SQLException
	{
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_INT_TYPE_ID )
			return new String("int");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_VARCHAR_TYPE_ID )
			return new String("String");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_FLOAT_TYPE_ID )
			return new String("Float");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_DOUBLE_TYPE_ID )
			return new String("Double");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_DECIMAL_TYPE_ID )
			return new String("BigDecimal");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_LONG_TYPE_ID )
			return new String("Long");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_SMALLINT_TYPE_ID )
			return new String("short");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_TINYINT_TYPE_ID )
			return new String("char");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_BLOB_TYPE_ID )
			return new String("Blob");
		if ( _colList.get(i-1).getColTypeId() == Constant.CEGO_CLOB_TYPE_ID )
			return new String("Clob");
		
		throw new SQLException("Unknown type id " + _colList.get(i-1).getColTypeId());
	}
	
	public boolean isWrapperFor(Class<?> iface) throws SQLException 
	{
		return iface.isInstance(this);	
	}
	
	public <T> T unwrap(Class<T> iface) throws SQLException
	{
		try {
			return iface.cast(this);
		} catch (ClassCastException cce) {
			throw new SQLException("Unable to wrap");
		}	
	}
	
	public boolean equals(Object o)
	{
		if ( this == o ) return true;
		if ( !(o instanceof CegoResultSetMetaData) ) return false;
		if ( ((CegoResultSetMetaData)o).getColumnList().size() != _colList.size()) return false;
		
		int i=0;
		for ( CegoField col : _colList )
		{
			if ( ((CegoResultSetMetaData)o).getColumnList().get(i).equals(col) == false )
			{
				return false;
			}
			i++;
		}
		return true;
	}
}
