//
// File: CegoXML.java
// This code was produced by the dragon parser generator
//
package de.lemkeit.cegojdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

class CegoXML
{

   final int MAXTOKENVAL = 1000;
   List<String> _tokenList = new ArrayList<String>();
   Token _reservedToken;
   boolean _isReserved;
   Token _token;
   char _tokenVal[] = new char[MAXTOKENVAL];
   int _tokenLen = 0;
   int _actNum;
   Action _actAction;
   int _actFState;
   
   enum Symbol { PROD, TOKEN, NONE };
   enum ScannerStateType { START, INTERMEDIATE, FINAL, ANY };
   enum Action { SHIFT, REDUCE, ACCEPT };
   enum Production {
        Start,
        XMLHeader,
        AttrList,
        Attr,
        XMLBody,
        XMLTag,
        Elem,
        ElementStart,
        ElementEnd,
        ElementList
    };
    public List<String> getTokenList() { return _tokenList; }

    // source stream 
    public char nextChar() throws Exception { return 0; };
    public void backChar() {};
    public void putPreamble() throws Exception {}
    public void putAttribute() throws Exception {}
    public void putBody() throws Exception {}
    public void putDocType() throws Exception {}
    public void putElement() throws Exception {}
    public void startElement() throws Exception {}
    public void endElement() throws Exception {}

    enum Token {
        IDENTIFIER,
        INTVAL,
        XMLTOKEN,
        EMARK,
        QMARK,
        SLASH,
        MT,
        LT,
        DOCTYPE,
        EQU,
        DATA,
        CONTENT,
        STRINGVAL,
        ENDTOKEN
    };
    void setReserved(Token t)
    {
       _reservedToken = t;
       _isReserved = true;
    }

   class ScannerStateEntry
   {
      int  _state;
      ScannerStateType _type;

      ScannerStateEntry() {};
      ScannerStateEntry(int state)
      {
         _state = state;
      };
      ScannerStateEntry(int state, ScannerStateType type)
      {
         _state = state;
         _type = type;
      };
      public int getState() { return _state; }
      public ScannerStateType getType() { return _type; }
      @Override
	public boolean equals(Object o)
      {
          if ( _state == ((ScannerStateEntry)o)._state )
             return true;
          return false;
      }
   }

   class ScannerTransEntry
   {

      int _state;
      int _fstate;
      char _c;

      ScannerTransEntry() {};
      ScannerTransEntry(int state, char c)
      {
         _state = state;
         _c = c;
      }
      ScannerTransEntry(int state, char c, int fstate)
      {
         _state = state;
         _fstate = fstate;
         _c = c;
      }

      @Override
	public boolean equals(Object o)
      {
          if ( _state == ((ScannerTransEntry)o)._state && _c == ((ScannerTransEntry)o)._c )
             return true;
          return false;
      }
      public int getFState() { return _fstate; };
   }

   class Scanner
   {
      Token _t;
      List<ScannerStateEntry> _stateList;
      List<ScannerTransEntry> _transList;
      Scanner()
      {
         _stateList = new ArrayList<ScannerStateEntry>();
         _transList = new ArrayList<ScannerTransEntry>();
      }
      Scanner(Token t)
      {
         _t = t;
         _stateList = new ArrayList<ScannerStateEntry>();
         _transList = new ArrayList<ScannerTransEntry>();
      }

      Token getToken() { return _t; }
      void addState(ScannerStateEntry s)
      {
         _stateList.add(s);
      }
      void addTransition(ScannerTransEntry t)
      {
         _transList.add(t);
      }
      public boolean checkPattern(String pattern)
      {
         int state = 0;
         int i = 0;
         while ( i < _stateList.size() )
         {
            ScannerStateEntry pS = _stateList.get(i);
            if (pS.getType() == ScannerStateType.START || pS.getType() == ScannerStateType.ANY)
            {
               state = pS.getState();
            }
            i++;
         }
         i = 0;
         if ( _transList.contains ( new ScannerTransEntry(state, pattern.charAt(i) ) ) )
         {
            ScannerTransEntry pT = _transList.get( _transList.indexOf(new ScannerTransEntry(state, pattern.charAt(i))));
            while ( pT != null )
            {
               if (_stateList.contains(new ScannerStateEntry(pT.getFState())))
               {
                  ScannerStateEntry pS = _stateList.get( _stateList.indexOf(new ScannerStateEntry(pT.getFState()))); 
                  if ( ( i == pattern.length()-1 ) && ( pS.getType() == ScannerStateType.FINAL || pS.getType() == ScannerStateType.ANY))
                  {
                     return true;
                  }
                  else
                  {
                     state = pT.getFState();
                  }
               }
               else
               {
                  return false;
               }
               i++;
               if ( i < pattern.length() && _transList.contains(new ScannerTransEntry(state, pattern.charAt(i))))
               {
                  pT = _transList.get( _transList.indexOf( new ScannerTransEntry(state, pattern.charAt(i))));
               }
               else
               {
                  return false;
               }
            }
         }
         return false;
      }
   };

   List<Scanner> _scannerList;
   class StackEntry {

      Symbol _symbol;
      int  _num;
      int  _state;
      String  _tval;

      StackEntry() { _symbol = Symbol.NONE; }
      StackEntry(Symbol prod, int num, int state, String tval)
      {
         _symbol = prod;
         _num = num;
         _state = state;
         _tval = tval;
      };

      public int getState() { return _state; }
      public Symbol getSymbol() { return _symbol; }
      public String getTval() { return _tval; }
   };

   class ActionEntry {

      int _state;
      Token _token;
      Action _action;
      int _num;	

      ActionEntry() {}
      ActionEntry(int state, Token token) { _state = state; _token = token; }
      ActionEntry(int state, Token token, Action action, int num)
      {
         _state=state;
         _token=token;
         _action=action;
         _num=num;
      }
      @Override
	public boolean equals(Object a)
      {
         if ( _state == ((ActionEntry)a)._state && _token == ((ActionEntry)a)._token )
            return true;
         return false;
      }

      public Action getAction() { return _action; }
      public int getNum() { return _num; }

   };

   List<ActionEntry> _actionMap;

   class JumpEntry {

 	   int _state;
	   Production _prod;
	   int _fstate;	

	   JumpEntry() {}
	   JumpEntry(int state, Production prod) { _state = state; _prod = prod; }
	   JumpEntry(int state, Production prod, int fstate) { _state = state; _prod = prod; _fstate = fstate; }
	   @Override
	public boolean equals(Object j)
      {
         if ( _state == ((JumpEntry)j)._state && _prod == ((JumpEntry)j)._prod )
            return true;
         return false;
      };

      public int getFState() { return _fstate; }

   }

   List<JumpEntry> _jumpMap;

   class ProdEntry {

	   int _id;
	   Production _prod;
	   int _numSymbol;

	   ProdEntry() {};
	   ProdEntry(int id) { _id = id; }
	   ProdEntry(int id, Production prod, int numSymbol)
      {
         _id = id;
         _prod = prod;
         _numSymbol = numSymbol;
      }
      @Override
	public boolean equals(Object p)
      {
         if ( _id == ((ProdEntry)p)._id )
            return true;
         return false;
      };

      public int getId() { return _id; }
      public Production getProd() { return _prod; }
      int getNumSymbol() { return _numSymbol; }

   }

   List<ProdEntry> _prodInfo;

   boolean isSepIgnore(char c)
   {
      if (c == '\t') return true;
      if (c == '\n') return true;
      if (c == '\r') return true;
      if (c == ' ') return true;
      return false;
   }
   boolean isSepSign(char c)
   {
   if (c == '=') return true;
   if (c == '/') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == '?') return true;
   if (c == '!') return true;
      return false;
   }
   boolean shiftToken() throws Exception
   {
      int i=0;
      char c;
      while ( isSepIgnore(c = nextChar()) && ! _isReserved );
      if ( _isReserved )
      {
         _token = _reservedToken;
         _isReserved = false;
         return true;
      }
      if (c == 0)
      {
         _token = Token.ENDTOKEN;
         return true;
      }
      if (isSepSign(c))
      {
         _tokenVal[i]=c;
          i++;
      }
      else
      {
         while (c != 0 && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
         {
            _tokenVal[i]=c;
            i++;
            c = nextChar();
         }
         if (isSepSign(c)) backChar();
      }
      _tokenVal[i]=0;
      _tokenLen=i;
      int j=0;
      Scanner pS;
      while (j < _scannerList.size() )
      {
         pS=_scannerList.get(j);
         if (pS.checkPattern(new String(_tokenVal, 0, i)))
         {
            _token = pS.getToken();
            return true;
         }
         j++;
      }
      return false;
   }
   public void parse() throws Exception
   {
	  Stack<StackEntry> s = new Stack<StackEntry>();
      StackEntry se = new StackEntry(Symbol.NONE, 0, 0, new String());
      s.push(se);    
      if ( shiftToken() == false )
      {
         throw new Exception("Invalid token <" + new String(_tokenVal, 0, _tokenLen) + ">.");
      }
      while ( true )
      {
         if ( getAction(s.peek().getState(), _token) )
         {
            if (_actAction == Action.SHIFT )
            {
               StackEntry ste = new StackEntry(Symbol.TOKEN, _token.ordinal(), _actNum, new String(_tokenVal, 0, _tokenLen));
               s.push(ste);
               if ( shiftToken() == false )
               {
                  throw new Exception("Invalid token <" + new String(_tokenVal, 0, _tokenLen) + ">.");
               }
            }
            else if ( _actAction == Action.REDUCE)
            {
               _tokenList.clear();
               ProdEntry pPE = null;
               if (  _prodInfo.contains( new ProdEntry(_actNum) ) )
               {
                  pPE = _prodInfo.get( _prodInfo.indexOf( new ProdEntry(_actNum) ) );
               }
               for (int i=0; i<pPE.getNumSymbol();i++)
               {
                  StackEntry ste = s.pop();
                  if (ste.getSymbol() == Symbol.TOKEN)
                     _tokenList.add(ste.getTval());
               }
               if (getJump(s.peek().getState(), pPE.getProd()))
               {
                  StackEntry ste = new StackEntry(Symbol.PROD, pPE.getId(), _actFState, new String(_tokenVal, 0, _tokenLen));
                  s.push(ste);
               }
               else
               {
                  throw new Exception("Cannot reduce after token <" + new String(_tokenVal, 0, _tokenLen) + ">.");
               }
               switch (_actNum)
               {
                  case 12:
                     endElement();
                     break;
                  case 11:
                     startElement();
                     break;
                  case 9:
                     putElement();
                     break;
                  case 8:
                     putDocType();
                     break;
                  case 7:
                     putBody();
                     break;
                  case 4:
                     putAttribute();
                     break;
                  case 1:
                     putPreamble();
                     break;
               }
               _tokenList.clear();
            }
            else if ( _actAction ==  Action.ACCEPT )
            {
               return;
            }
         }
         else
         {
            throw new Exception("Parse error at token <" + new String(_tokenVal, 0, _tokenLen) + ">.");
         }
      }
   }

   boolean getAction(int state, Token token)
   {
      ActionEntry pA = null;
      if (  _actionMap.contains( new ActionEntry(state, token)))
      {
         pA = _actionMap.get( _actionMap.indexOf( new  ActionEntry(state, token)));
      }
      if (pA != null )
      {
         _actAction = pA.getAction();
	      _actNum = pA.getNum();
	      return true;
      }
      else
      {
         return false;
      }
   }

   boolean getJump(int state, Production prod)
   {
      JumpEntry pJ = null;
      if (  _jumpMap.contains( new JumpEntry(state, prod)))
      {
         pJ = _jumpMap.get( _jumpMap.indexOf( new JumpEntry(state, prod)));
      }
      if (pJ != null)
      {
         _actFState = pJ.getFState();
	      return true;
      }
      else
      {
	      return false;
      }
   }

   void loadScanner()
   {

      Scanner s0 = new Scanner(Token.EQU);
      s0.addState(new ScannerStateEntry(0 ,ScannerStateType.START));
      s0.addState(new ScannerStateEntry(1 ,ScannerStateType.FINAL));
      s0.addTransition(new ScannerTransEntry(0 ,'=' ,1));
      _scannerList.add(s0);

      Scanner s1 = new Scanner(Token.DOCTYPE);
      s1.addState(new ScannerStateEntry(0 ,ScannerStateType.INTERMEDIATE));
      s1.addState(new ScannerStateEntry(1 ,ScannerStateType.INTERMEDIATE));
      s1.addState(new ScannerStateEntry(2 ,ScannerStateType.START));
      s1.addState(new ScannerStateEntry(3 ,ScannerStateType.INTERMEDIATE));
      s1.addState(new ScannerStateEntry(4 ,ScannerStateType.INTERMEDIATE));
      s1.addState(new ScannerStateEntry(5 ,ScannerStateType.INTERMEDIATE));
      s1.addState(new ScannerStateEntry(6 ,ScannerStateType.INTERMEDIATE));
      s1.addState(new ScannerStateEntry(7 ,ScannerStateType.FINAL));
      s1.addTransition(new ScannerTransEntry(0 ,'O' ,1));
      s1.addTransition(new ScannerTransEntry(1 ,'C' ,3));
      s1.addTransition(new ScannerTransEntry(2 ,'D' ,0));
      s1.addTransition(new ScannerTransEntry(3 ,'T' ,4));
      s1.addTransition(new ScannerTransEntry(4 ,'Y' ,5));
      s1.addTransition(new ScannerTransEntry(5 ,'P' ,6));
      s1.addTransition(new ScannerTransEntry(6 ,'E' ,7));
      _scannerList.add(s1);

      Scanner s2 = new Scanner(Token.LT);
      s2.addState(new ScannerStateEntry(0 ,ScannerStateType.START));
      s2.addState(new ScannerStateEntry(1 ,ScannerStateType.FINAL));
      s2.addTransition(new ScannerTransEntry(0 ,'<' ,1));
      _scannerList.add(s2);

      Scanner s3 = new Scanner(Token.MT);
      s3.addState(new ScannerStateEntry(0 ,ScannerStateType.START));
      s3.addState(new ScannerStateEntry(1 ,ScannerStateType.FINAL));
      s3.addTransition(new ScannerTransEntry(0 ,'>' ,1));
      _scannerList.add(s3);

      Scanner s4 = new Scanner(Token.SLASH);
      s4.addState(new ScannerStateEntry(0 ,ScannerStateType.START));
      s4.addState(new ScannerStateEntry(1 ,ScannerStateType.FINAL));
      s4.addTransition(new ScannerTransEntry(0 ,'/' ,1));
      _scannerList.add(s4);

      Scanner s5 = new Scanner(Token.QMARK);
      s5.addState(new ScannerStateEntry(0 ,ScannerStateType.START));
      s5.addState(new ScannerStateEntry(1 ,ScannerStateType.FINAL));
      s5.addTransition(new ScannerTransEntry(0 ,'?' ,1));
      _scannerList.add(s5);

      Scanner s6 = new Scanner(Token.EMARK);
      s6.addState(new ScannerStateEntry(0 ,ScannerStateType.START));
      s6.addState(new ScannerStateEntry(1 ,ScannerStateType.FINAL));
      s6.addTransition(new ScannerTransEntry(0 ,'!' ,1));
      _scannerList.add(s6);

      Scanner s7 = new Scanner(Token.XMLTOKEN);
      s7.addState(new ScannerStateEntry(0 ,ScannerStateType.INTERMEDIATE));
      s7.addState(new ScannerStateEntry(1 ,ScannerStateType.INTERMEDIATE));
      s7.addState(new ScannerStateEntry(2 ,ScannerStateType.START));
      s7.addState(new ScannerStateEntry(3 ,ScannerStateType.FINAL));
      s7.addTransition(new ScannerTransEntry(0 ,'m' ,1));
      s7.addTransition(new ScannerTransEntry(1 ,'l' ,3));
      s7.addTransition(new ScannerTransEntry(2 ,'x' ,0));
      _scannerList.add(s7);

      Scanner s8 = new Scanner(Token.INTVAL);
      s8.addState(new ScannerStateEntry(0 ,ScannerStateType.START));
      s8.addState(new ScannerStateEntry(1 ,ScannerStateType.FINAL));
      s8.addState(new ScannerStateEntry(2 ,ScannerStateType.FINAL));
      s8.addTransition(new ScannerTransEntry(0 ,'1' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'2' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'3' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'4' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'5' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'6' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'7' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'8' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'9' ,1));
      s8.addTransition(new ScannerTransEntry(0 ,'0' ,2));
      s8.addTransition(new ScannerTransEntry(1 ,'0' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'1' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'2' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'3' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'4' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'5' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'6' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'7' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'8' ,1));
      s8.addTransition(new ScannerTransEntry(1 ,'9' ,1));
      _scannerList.add(s8);

      Scanner s9 = new Scanner(Token.IDENTIFIER);
      s9.addState(new ScannerStateEntry(0 ,ScannerStateType.START));
      s9.addState(new ScannerStateEntry(1 ,ScannerStateType.FINAL));
      s9.addTransition(new ScannerTransEntry(0 ,'A' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'B' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'C' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'D' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'E' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'F' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'G' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'H' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'I' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'J' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'K' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'L' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'M' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'N' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'O' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'P' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'Q' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'R' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'S' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'T' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'U' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'V' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'W' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'X' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'Y' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'Z' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'a' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'b' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'c' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'d' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'e' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'f' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'g' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'h' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'i' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'j' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'k' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'l' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'m' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'n' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'o' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'p' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'q' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'r' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'s' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'t' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'u' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'v' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'w' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'x' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'y' ,1));
      s9.addTransition(new ScannerTransEntry(0 ,'z' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'-' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'.' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'0' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'1' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'2' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'3' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'4' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'5' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'6' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'7' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'8' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'9' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'A' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'B' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'C' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'D' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'E' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'F' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'G' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'H' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'I' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'J' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'K' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'L' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'M' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'N' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'O' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'P' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'Q' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'R' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'S' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'T' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'U' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'V' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'W' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'X' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'Y' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'Z' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'_' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'a' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'b' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'c' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'d' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'e' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'f' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'g' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'h' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'i' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'j' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'k' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'l' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'m' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'n' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'o' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'p' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'q' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'r' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'s' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'t' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'u' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'v' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'w' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'x' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'y' ,1));
      s9.addTransition(new ScannerTransEntry(1 ,'z' ,1));
      _scannerList.add(s9);

   }
   void loadParser0()
   {
      _actionMap.add(new ActionEntry(32, Token.LT, Action.REDUCE, 12));
      _actionMap.add(new ActionEntry(32, Token.ENDTOKEN, Action.REDUCE, 12));
      _actionMap.add(new ActionEntry(33, Token.QMARK, Action.REDUCE, 4));
      _actionMap.add(new ActionEntry(33, Token.SLASH, Action.REDUCE, 4));
      _actionMap.add(new ActionEntry(33, Token.IDENTIFIER, Action.REDUCE, 4));
      _actionMap.add(new ActionEntry(33, Token.MT, Action.REDUCE, 4));
      _actionMap.add(new ActionEntry(29, Token.MT, Action.SHIFT, 32));
      _actionMap.add(new ActionEntry(30, Token.ENDTOKEN, Action.REDUCE, 8));
      _actionMap.add(new ActionEntry(30, Token.LT, Action.REDUCE, 8));
      _actionMap.add(new ActionEntry(31, Token.STRINGVAL, Action.SHIFT, 33));
      _actionMap.add(new ActionEntry(23, Token.IDENTIFIER, Action.SHIFT, 29));
      _actionMap.add(new ActionEntry(24, Token.MT, Action.SHIFT, 30));
      _actionMap.add(new ActionEntry(25, Token.QMARK, Action.REDUCE, 2));
      _actionMap.add(new ActionEntry(25, Token.SLASH, Action.REDUCE, 2));
      _actionMap.add(new ActionEntry(25, Token.IDENTIFIER, Action.REDUCE, 2));
      _actionMap.add(new ActionEntry(25, Token.MT, Action.REDUCE, 2));
      _actionMap.add(new ActionEntry(26, Token.EQU, Action.SHIFT, 31));
      _actionMap.add(new ActionEntry(27, Token.ENDTOKEN, Action.REDUCE, 9));
      _actionMap.add(new ActionEntry(27, Token.LT, Action.REDUCE, 9));
      _actionMap.add(new ActionEntry(28, Token.ENDTOKEN, Action.REDUCE, 1));
      _actionMap.add(new ActionEntry(28, Token.LT, Action.REDUCE, 1));
      _actionMap.add(new ActionEntry(14, Token.LT, Action.REDUCE, 13));
      _actionMap.add(new ActionEntry(15, Token.LT, Action.REDUCE, 10));
      _actionMap.add(new ActionEntry(15, Token.ENDTOKEN, Action.REDUCE, 10));
      _actionMap.add(new ActionEntry(16, Token.SLASH, Action.SHIFT, 23));
      _actionMap.add(new ActionEntry(16, Token.IDENTIFIER, Action.SHIFT, 12));
      _actionMap.add(new ActionEntry(17, Token.IDENTIFIER, Action.SHIFT, 24));
      _actionMap.add(new ActionEntry(18, Token.SLASH, Action.SHIFT, 20));
      _actionMap.add(new ActionEntry(18, Token.MT, Action.SHIFT, 19));
      _actionMap.add(new ActionEntry(18, Token.IDENTIFIER, Action.SHIFT, 26));
      _jumpMap.add(new JumpEntry(18, Production.Attr, 25));
      _actionMap.add(new ActionEntry(19, Token.LT, Action.REDUCE, 11));
      _actionMap.add(new ActionEntry(20, Token.MT, Action.SHIFT, 27));
      _actionMap.add(new ActionEntry(21, Token.QMARK, Action.SHIFT, 22));
      _actionMap.add(new ActionEntry(21, Token.IDENTIFIER, Action.SHIFT, 26));
      _jumpMap.add(new JumpEntry(21, Production.Attr, 25));
      _actionMap.add(new ActionEntry(22, Token.MT, Action.SHIFT, 28));
      _actionMap.add(new ActionEntry(9, Token.ENDTOKEN, Action.REDUCE, 5));
      _actionMap.add(new ActionEntry(10, Token.LT, Action.SHIFT, 16));
      _jumpMap.add(new JumpEntry(10, Production.ElementEnd, 15));
      _jumpMap.add(new JumpEntry(10, Production.ElementStart, 6));
      _jumpMap.add(new JumpEntry(10, Production.Elem, 14));
      _actionMap.add(new ActionEntry(11, Token.DOCTYPE, Action.SHIFT, 17));
      _actionMap.add(new ActionEntry(12, Token.IDENTIFIER, Action.REDUCE, 3));
      _actionMap.add(new ActionEntry(12, Token.SLASH, Action.REDUCE, 3));
      _actionMap.add(new ActionEntry(12, Token.MT, Action.REDUCE, 3));
      _jumpMap.add(new JumpEntry(12, Production.AttrList, 18));
      _actionMap.add(new ActionEntry(13, Token.IDENTIFIER, Action.REDUCE, 3));
      _actionMap.add(new ActionEntry(13, Token.QMARK, Action.REDUCE, 3));
      _jumpMap.add(new JumpEntry(13, Production.AttrList, 21));
   }
   void loadParser1()
   {
      _actionMap.add(new ActionEntry(3, Token.ENDTOKEN, Action.ACCEPT, 0));
      _actionMap.add(new ActionEntry(4, Token.LT, Action.SHIFT, 7));
      _actionMap.add(new ActionEntry(4, Token.ENDTOKEN, Action.REDUCE, 6));
      _jumpMap.add(new JumpEntry(4, Production.ElementStart, 6));
      _jumpMap.add(new JumpEntry(4, Production.Elem, 5));
      _jumpMap.add(new JumpEntry(4, Production.XMLTag, 4));
      _jumpMap.add(new JumpEntry(4, Production.XMLBody, 9));
      _actionMap.add(new ActionEntry(5, Token.ENDTOKEN, Action.REDUCE, 7));
      _actionMap.add(new ActionEntry(5, Token.LT, Action.REDUCE, 7));
      _actionMap.add(new ActionEntry(6, Token.LT, Action.REDUCE, 14));
      _jumpMap.add(new JumpEntry(6, Production.ElementList, 10));
      _actionMap.add(new ActionEntry(7, Token.IDENTIFIER, Action.SHIFT, 12));
      _actionMap.add(new ActionEntry(7, Token.EMARK, Action.SHIFT, 11));
      _actionMap.add(new ActionEntry(8, Token.XMLTOKEN, Action.SHIFT, 13));
      _actionMap.add(new ActionEntry(1, Token.LT, Action.SHIFT, 7));
      _actionMap.add(new ActionEntry(1, Token.ENDTOKEN, Action.REDUCE, 6));
      _jumpMap.add(new JumpEntry(1, Production.ElementStart, 6));
      _jumpMap.add(new JumpEntry(1, Production.Elem, 5));
      _jumpMap.add(new JumpEntry(1, Production.XMLTag, 4));
      _jumpMap.add(new JumpEntry(1, Production.XMLBody, 3));
      _actionMap.add(new ActionEntry(2, Token.QMARK, Action.SHIFT, 8));
      _actionMap.add(new ActionEntry(0, Token.LT, Action.SHIFT, 2));
      _jumpMap.add(new JumpEntry(0, Production.XMLHeader, 1));
   }
   CegoXML()
   {
      _prodInfo = new ArrayList<ProdEntry>();
      _scannerList = new ArrayList<Scanner>();
      _actionMap = new ArrayList<ActionEntry>();
      _jumpMap = new ArrayList<JumpEntry>();
      loadScanner();
      loadParser0();
      loadParser1();
      _prodInfo.add(new ProdEntry(14, Production.ElementList, 0));
      _prodInfo.add(new ProdEntry(13, Production.ElementList, 2));
      _prodInfo.add(new ProdEntry(12, Production.ElementEnd, 4));
      _prodInfo.add(new ProdEntry(11, Production.ElementStart, 4));
      _prodInfo.add(new ProdEntry(10, Production.Elem, 3));
      _prodInfo.add(new ProdEntry(9, Production.Elem, 5));
      _prodInfo.add(new ProdEntry(8, Production.XMLTag, 5));
      _prodInfo.add(new ProdEntry(7, Production.XMLTag, 1));
      _prodInfo.add(new ProdEntry(6, Production.XMLBody, 0));
      _prodInfo.add(new ProdEntry(5, Production.XMLBody, 2));
      _prodInfo.add(new ProdEntry(4, Production.Attr, 3));
      _prodInfo.add(new ProdEntry(3, Production.AttrList, 0));
      _prodInfo.add(new ProdEntry(2, Production.AttrList, 2));
      _prodInfo.add(new ProdEntry(1, Production.XMLHeader, 6));
      _prodInfo.add(new ProdEntry(0, Production.Start, 2));
      _isReserved = false;
   }
};
