package de.lemkeit.cegojdbc;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CegoXMLGram extends CegoXML {


	private char[] _stringBuf = new char[Constant.MAXSTRINGLEN];
	private int _stringBufLen;

	private String _name = null;
	
	private String _xmlString;
	
	private Hashtable<String, String> _faList = null;
	private Hashtable<String, String> _attList = null;
	
	private LinkedList<CegoDataRow> _rowList = null;
	private LinkedList<CegoDataRow> _schema = null;
	private LinkedList<CegoDataRow> _outparamList = null;
	
	private int _i;
	
	public CegoXMLGram()
	{
		_i = 0;
		_rowList = new LinkedList<CegoDataRow>();
		_schema = new LinkedList<CegoDataRow>();
		_outparamList = new LinkedList<CegoDataRow>();
		_faList = new Hashtable<String, String>();
	}
	
	public CegoXMLGram(String xmlString)
	{
		
		_xmlString = xmlString;
		_i = 0;
		_rowList = new LinkedList<CegoDataRow>();
		_schema = new LinkedList<CegoDataRow>();
		_outparamList = new LinkedList<CegoDataRow>();
		_faList = new Hashtable<String, String>();		
	}
	
	public void setXML(String xmlString)
	{
		_xmlString = xmlString;
		_i=0;
		_rowList.clear(); // = new LinkedList<CegoDataRow>();
		_schema.clear(); // = new LinkedList<CegoDataRow>();
		_outparamList.clear(); // = new LinkedList<CegoDataRow>();
		if ( _faList != null)
		{
			_faList.clear(); // = new Hashtable<String, String>();
		}
	}
	 // source stream 
    @Override
	public char nextChar() throws Exception 
    {
    	if ( _i >= _xmlString.length())
    		return 0;
    	else
    	{    		
    		if ( _xmlString.charAt(_i) == '"')
    		{
    			_i++;
    			try {
    				readString();
    			} catch (Exception e) {
    				// TODO Auto-generated catch block
    				e.printStackTrace();
    			}
    			return 0;
    		}
    		
    		char c = _xmlString.charAt(_i);
    		_i++;
    		// System.out.println("Read char " + c);
    		return c;
    	}
    }

    void readString() throws Exception
	{
    	int i = 0;
	    setReserved(CegoXML.Token.STRINGVAL);

	    while ( _xmlString.charAt(_i) != '"')
	    {

	    	if ( _xmlString.charAt(_i) == '\\')
	    	{
	    		_i++;

	    		if ( _xmlString.charAt(_i) == 'n')
	    		{
	    			_stringBuf[i] = '\n';
	    		}
	    		else if (  _xmlString.charAt(_i)== 't')
	    		{
	    			_stringBuf[i] = '\t';
	    		}
	    		else if (  _xmlString.charAt(_i) == '\'')
	    		{
	    			_stringBuf[i] = '\'';
	    		}
	    		else if (  _xmlString.charAt(_i) == '\\')
	    		{
	    			_stringBuf[i] = '\\';
	    		}
	    		else
	    		{
	    			throw new Exception("Invalid escape character");
	    		}
	    	}
	    	else
	    	{
	    		_stringBuf[i] = _xmlString.charAt(_i);
	    	}
	    	i++;
	    	if (i == Constant.MAXSTRINGLEN)
	    	{
	    		throw new Exception("Stringbuf exceeded");
	    	}
	    	_i++;
	    	if ( _xmlString.charAt(_i) == 0 )
	    	{
	    			throw new Exception("Unexpected end of string");
	    	}
	    }
	    _stringBufLen = i;
	    _stringBuf[i] = 0;

	    _i++;

	    return;
	}
    
    @Override
	public void backChar() 
    {
    	if ( _i > 0 )
    		_i--;
    }
    
    @Override
	public void putPreamble() throws Exception 
    {
    	if ( _attList != null )
    	{
    		_attList.clear();
    	}
    }
    
    @Override
	public void putAttribute() throws Exception 
    {
    	if ( _attList == null )
    	{
    		_attList = new Hashtable<String, String>();
    	}
    	String attName = getTokenList().get(2);
    	// System.out.println("Putting attribute " + attName + " =  " + new String(_stringBuf, 0, _stringBufLen));
    	_attList.put(attName, new String(_stringBuf, 0, _stringBufLen));
    }
    
    @Override
	public void putBody() throws Exception 
    {
    	
    }
    
    @Override
	public void putDocType() throws Exception 
    {
    	// String docType = getTokenList().get(1);
    	_name = getTokenList().get(1);
    }
    
    @Override
	public void putElement() throws Exception 
    {
    	
    }
    
    @Override
	public void startElement() throws Exception 
    {

    	String elementName = getTokenList().get(1);
    	if ( elementName.equals(Constant.XML_FRAME_ELEMENT) )
    	{
    		_faList = _attList;
    	}
    	if ( elementName.equals(Constant.XML_ROW_ELEMENT) )
    	{
    		_rowList.add( new CegoDataRow(_attList));
    	}
    	else if ( elementName.equals(Constant.XML_OUTPARAM_ELEMENT) )
    	{
    		_outparamList.add( new CegoDataRow(_attList));
    	}
    	else if ( elementName.equals(Constant.XML_SCHEMA_ELEMENT) )
    	{
    		_schema.add( new CegoDataRow(_attList));
    	}
    	_attList = null;
    	
    	// System.out.println("Starting element " + elementName);

    }
    
    @Override
	public void endElement() throws Exception 
    {
    	
    }

    public String getName()
    {
    	return _name;
    }
    
    public void setName(String name)
    {
    	_name = name;
    }
    
    public String toXML()
    {
    	String xmlString = new String("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
    	
    	xmlString += new String("<!DOCTYPE " + _name + ">");
    	
    	xmlString += new String("<FRAME ");
    	
    	Iterator<String> it = _faList.keySet().iterator();
    	while ( it.hasNext() )
    	{
    		String key = it.next();
    		xmlString += key + new String("=\"") + _faList.get(key) + new String("\" ");
    	}

    	xmlString += new String("></FRAME>");

    	return xmlString;
    }
    
    public void setAttribute(String key, String value)
    {
    	_faList.put(key, value);
    }
    
    public String getAttribute(String key)
    {
    	return _faList.get(key);
    }
    
    public List<CegoField> getSchema()
    {
    	
    	List<CegoField> cegoschema = new ArrayList<CegoField>();

    	for ( int i=0; i< _schema.size() ; i++)
    	{
    		CegoDataRow r =  _schema.get(i);
    		cegoschema.add(new CegoField(r.getValue(Constant.XML_COLNAME_ATTR),
    				Integer.valueOf ( r.getValue(Constant.XML_COLTYPEID_ATTR)).intValue(),
    				Integer.valueOf ( r.getValue(Constant.XML_COLSIZE_ATTR) ).intValue(),
    				Integer.valueOf ( r.getValue(Constant.XML_JAVATYPE_ATTR) ).intValue()));
    	}			

    	return cegoschema;
    }
    
    public List<CegoDataRow> getRowList()
    {
    	return _rowList;
    }

    public List<CegoDataRow> getOutParamList()
    {
    	return _outparamList;
    }

    public static void main(String[] args) throws Exception 
	{
    
    	String xmlString = "<?xml  version=\"1.0\" encoding=\"UTF-8\" ?>" +
    			"<!DOCTYPE DATA>" +
    			"<FRAME a=\"alpha\" b=\"beta\">" +
    			"<ROW c1=\"XXXXXXX\" c2=\"12\"></ROW>" +
    			"<ROW c1=\"YYYYYYYYY\" c2=\"43\"></ROW>" +
    			"</FRAME>";
    	
    	CegoXMLGram xg = new CegoXMLGram(xmlString);
    	xg.parse();
    	
    	System.out.println(xg.toXML());
	}
    	
}
