package de.lemkeit.cegojdbc;

public class Constant {

	
	public final static String JDBC_DRIVERNAME = "Cego-JDBC";

	public final static int JDBC_MAJORVERSION = 1;
	public final static int JDBC_MINORVERSION = 15;
	public final static int JDBC_PATCHVERSION = 0;
	
	public final static String CEGO_COMPATIBLE_VERSIONS = "2.49.,2.50.,2.51.,2.52.,2.53.";
	
	public static int NETMSG_JDOM = 1;
	public static int NETMSG_XMLNATIVE = 2;
	public static int NETMSG_SERIAL = 3;
	public static int NETMSG_FASTSERIAL = 4;
	

	public static String CHARSET = "UTF-8";
	public final static String ENCODING = "UTF-8";
	
	public final static int MAXSTRINGLEN = 10000;
	
	// The message buffer len for network messages.
	// This buffer should be large enough to receive a tuple chunk send by the database server
	
	public final static int INITMSGBUFLEN = 100000;
	
	public final static int FASTBUFFER = 1000;
	
	// SIZEBUF len must be correlated to the constant value in NetHandler base class 
	public final static int SIZEBUFLEN = 10;
	public final static int CHUNKBUFSIZE = 1024;
	
	public final static int QUERY_TIMEOUT = 60;
	public final static int FETCHSIZE = 60;

	public final static int MAXBLOBSIZE = 2000000000;
	public final static int BLOBCHUNKSIZE = 16384;
	
	
	// final static String SALT = "$1$hgz";
	
	public final static int CEGOAESKEYLEN = 128;
	public final static String CEGOAESKEY = "thisisthecegoaeskey";
		
	public final static String JDBC_PROTOCOL_SERIAL = "serial";
	public final static String JDBC_PROTOCOL_FASTSERIAL = "fastserial";
	public final static String JDBC_PROTOCOL_JDOM = "xml";
	public final static String JDBC_PROTOCOL_NATIVE = "native";
	
	
	public final static String CEGO_INT_TYPE= "int";
	public final static String CEGO_SMALLINT_TYPE= "smallint";
	public final static String CEGO_BIGINT_TYPE= "bigint";
	public final static String CEGO_TINYINT_TYPE= "tinyint";
	public final static String CEGO_STRING_TYPE= "string";
	public final static String CEGO_NULL_TYPE= "null";
	public final static String CEGO_LONG_TYPE= "long";
	public final static String CEGO_DATETIME_TYPE= "datetime";
	public final static String CEGO_FLOAT_TYPE= "float";
	public final static String CEGO_DOUBLE_TYPE= "double";
	public final static String CEGO_DECIMAL_TYPE="decimal";
	public final static String CEGO_BLOB_TYPE= "blob";
	

	public final static int CEGO_INT_TYPE_ID = 0;
	public final static int CEGO_LONG_TYPE_ID = 1;
	public final static int CEGO_VARCHAR_TYPE_ID = 2;
	public final static int CEGO_BOOL_TYPE_ID = 3;
	public final static int CEGO_DATETIME_TYPE_ID = 4;
	public final static int CEGO_BIGINT_TYPE_ID = 5;
	public final static int CEGO_FLOAT_TYPE_ID = 6;
	public final static int CEGO_DOUBLE_TYPE_ID = 7;
	public final static int CEGO_DECIMAL_TYPE_ID = 8;
	public final static int CEGO_SMALLINT_TYPE_ID = 9;
	public final static int CEGO_TINYINT_TYPE_ID = 10;
	public final static int CEGO_BLOB_TYPE_ID = 11;
	public final static int CEGO_CLOB_TYPE_ID = 12;
	public final static int CEGO_NULL_TYPE_ID = 13;
	  		
	public final static String SQL_KEYWORDS = "add,and,all,alter," +
			"append,as,asc,authorize,avg,balance,begin,bigint," +
			"bool,by,call,check,close,commit,column,constraint,count," +
			"create,cursor,date,date2str,datetime,decimal,delete,desc," +
			"distinct,double,drop,dump,else,elsif,end,exception,exists," +
			"false,fetch,float,for,foreign,from,getpos,group,having," +
			"identified,if,in,index,inner,int,into,insert,is,jdbc,join,key," +
			"left,length,like,list,load,locks,long,lower,min,max,modify,not," +
			"null,off,on,out,outer,or,order,orderspace,plan,pool,primary,print," +
			"procedure,quit,randstr,randint,rbseg,references,rename,return,remove," +
			"replace,right,rollback,rowlimit,select,set,show,smallint,string," +
			"substr,sum,sync,sysdate,system,systemspace,tableinfo,table,tableset," +
			"then,tinyint,str2int,str2long,to,trim,true,trunc,union,unique,update," +
			"upper,user,var,values,view,when,where,while";
	public final static String NUMERIC_FUNCTIONS = "";
	public final static String STRING_FUNCTIONS = "trim,trunc,,lower," +
			"upper,left,right,substr,getpos," +
			"str2int,str2long,replace";
	public final static String SYSTEM_FUNCTIONS = "randstr,randint";
	public final static String TIMEDATE_FUNCTIONS = "date2str";
	public final static String EXTRA_CHARS = "_";	
	public final static String SCHEMA_TERM = "TABLESET";
	public final static String PROC_TERM = "PROCEDURE";
	public final static String CATALOG_TERM = "DATABASE";
		
	public final static String SEARCH_STRING_ESCAPE = "\\";
	
	public final static String XML_DBSESSION_REQUEST = "DBSESSION";
	public final static String XML_SESSIONCLOSE_REQUEST = "CLOSE";
	public final static String XML_QUERY_REQUEST = "QUERY";
	public final static String XML_PROCCALL_REQUEST = "PROCCALL";
	public final static String XML_PUTBLOB_REQUEST = "PUTBLOB";
	public final static String XML_GETBLOB_REQUEST = "GETBLOB";
	public final static String XML_PUTCLOB_REQUEST = "PUTCLOB";
	public final static String XML_GETCLOB_REQUEST = "GETCLOB";

	public final static String XML_FRAME_ELEMENT = "FRAME";

	public final static String XML_SCHEMA_ELEMENT = "SCHEMA";
	public final static String XML_ROW_ELEMENT = "ROW";
	public final static String XML_OUTPARAM_ELEMENT = "OUTPARAM";

	
	public final static String XML_AFFECTED_ATTR = "AFFECTED";
	public final static String XML_CMD_ATTR = "CMD";
	public final static String XML_COLNAME_ATTR = "COLNAME";
	public final static String XML_COLTYPE_ATTR = "COLTYPE";
	public final static String XML_COLTYPEID_ATTR = "COLTYPEID";

	public final static String XML_COLSIZE_ATTR = "COLSIZE";
	
	public final static String XML_JAVATYPE_ATTR = "JAVATYPE";
	
	public final static String XML_USER_ATTR = "USER";
	public final static String XML_PASSWD_ATTR = "PASSWD";
	public final static String XML_DBPRODNAME_ATTR = "DBPRODNAME";
	public final static String XML_DBPRODVERSION_ATTR = "DBPRODVERSION";
	public final static String XML_DATETIMEFORMAT_ATTR = "DATETIMEFORMAT";
	public final static String XML_MSG_ATTR = "MSG";
	public final static String XML_NAME_ATTR = "NAME";
	public final static String XML_VALUE_ATTR = "VALUE";
	public final static String XML_TYPE_ATTR = "TYPE";
	public final static String XML_TABLESET_ATTR = "TABLESET";
	public final static String XML_SIZE_ATTR = "SIZE";
	public final static String XML_TID_ATTR = "TID";
	
	public final static String XML_FILEID_ATTR = "FILEID";
	public final static String XML_PAGEID_ATTR = "PAGEID";
	
	public final static String XML_TRUE_VALUE = "TRUE";
	public final static String XML_FALSE_VALUE = "FALSE";
	
	public final static String XML_READ_COMMITTED_VALUE = "READ_COMMITTED";
	public final static String XML_READ_UNCOMMITTED_VALUE = "READ_UNCOMMITTED";
	
	public final static String XML_NEWLINE = "&#xA;";
	public final static String XML_TAB = "&#x9;";
	public final static String QESC = "''";
	
	public final static char QUERY_MOREDATA = 0;
	public final static char QUERY_ABORT = 1;
	public final static char QUERY_RESET = 2;
	
	public final static String SER_SESSION = "ses";
	public final static String SER_SESSION_CLOSE = "sesclose";

	public final static String SER_NULL = "-";
	public final static String SER_SEP = "@";
	
	/*
	public final static String SER_ESCAPE = "^";
	public final static String SER_EESCAPE = "!^&";
	*/
	
	public final static String SER_ERROR = "err";
	public final static String SER_INFO = "inf";
	public final static String SER_SDATA = "sdt";
	public final static String SER_FDATA = "fdt";
	public final static String SER_FIN = "fin";
	public final static String SER_QUERY = "qry";
	public final static String SER_OK = "ok";
	public final static String SER_SACK = "sac";
	public final static String SER_PROCRES = "pcr";
	
	public final static String SER_BLOBINFO = "bli";
	public final static String SER_BLOBSIZE = "bls";
	
	public final static String SER_CLOBINFO = "cli";
	public final static String SER_CLOBSIZE = "cls";
	
	public final static String SER_PUTBLOB = "blp";
	public final static String SER_GETBLOB = "blg";
	public final static String SER_DELBLOB = "bld";

	public final static String SER_PUTCLOB = "clp";
	public final static String SER_GETCLOB = "clg";
	public final static String SER_DELCLOB = "cld";

	// net message types
	public final static String DG_OK = "OK";
	public final static String DG_ERROR = "ERROR";
	public final static String DG_DATA = "DATA";
	public final static String DG_INFO = "INFO";
	public final static String DG_SACK = "SACK";
	public final static String DG_SCLS = "SCLS";
	public final static String DG_FIN = "FIN";
	public final static String DG_BLOBINFO = "BLOBINFO";
	public final static String DG_BLOBSIZE = "BLOBSIZE";
	public final static String DG_CLOBINFO = "CLOBINFO";
	public final static String DG_CLOBSIZE = "CLOBSIZE";
	
}
