package de.lemkeit.cegojdbc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class DriverTest 
{

	final static Logger _logger = LoggerFactory.getLogger(DriverTest.class);
	
	private static String _blobIn ="/Users/lemke/work/tmp/blobfile";
	private static String _blobOut ="/Users/lemke/work/tmp/outfile";

	private static boolean _testConnection=false;
	private static boolean _testBlob=false;
	private static boolean _testClob=false;

	private static boolean _testMultiThread=false;
	
	private static boolean _testMeta=false;
	private static boolean _testCustom=false;
	private static boolean _testBasic=false;
	private static boolean _testNested=false;
	
	private static String _dbUrl = "jdbc:cego:fastserial:localhost:2200:sysmt";
	private static String _dbUser = "lemke";
	private static String _dbPwd = "lemke";

	private static List<Connection> _conList;
	
	private final static int MAXTHREADNUM = 10;
	private final static int MAXTHREADOP = 10000;
	
	public class DBThread extends Thread 
	{

		private int _numCall;
		
		public DBThread(int numCall)
		{
			_numCall = numCall;
		}
		
		public void run()
		{

			System.out.print("DB Thread started");
			
			int i=0;
			while ( i < _numCall )				
			{
				Connection con = allocateConnection();

				if ( con != null )
				{
					i++;
					// System.out.println("Got connection ...");

					try 
					{

						Statement stmt = con.createStatement();
						// stmt.execute("select a, b from t2;");
						// stmt.close();


						stmt.execute("select a, b from t1");


						ResultSet rs = stmt.getResultSet();

						// we check to get header information
						ResultSetMetaData meta = rs.getMetaData();
						int colCount = meta.getColumnCount();

						String[]  headers = new String[colCount];
						for (int h = 1; h <= colCount; h++) {

							headers[h - 1] = meta.getColumnName(h);

							// System.out.println("Col = " + headers[h-1]);
						}

						while ( rs.next() ) 
						{
							int a = rs.getInt(1);
							String b = rs.getString(2);

							// System.out.println(a + " " + b);
						}

						long tid = Thread.currentThread().getId();
						System.out.println("TID " + tid + " - Call " + i + " done");

						stmt.close();
						// con.close();

						/*
					System.out.println("DBName ... " + con.getMetaData().getDatabaseProductName());
					System.out.println("DBVersion ... " + con.getMetaData().getDatabaseProductVersion());
					System.out.println("DriverVersion ... " + con.getMetaData().getDriverVersion());
						 */
					} 
					catch (SQLException e) 
					{
						// TODO Auto-generated catch block
						e.printStackTrace();
					}

					releaseConnection(con);
				}
				else
				{
					
					try {
						System.out.println("Waiting for connection ..");
						Thread.sleep(1000);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}		
		}

		public synchronized Connection allocateConnection()
		{
			Connection con = null;
			if ( _conList.size() > 0 )
			{
				con = _conList.get(0);
				_conList.remove(0);
			}
			return con;
		}

		public synchronized void releaseConnection(Connection con)
		{
			_conList.add(con);
		}
	}

	
	public static void main(String[] args) throws Exception 
	{
						
		
		/*
		CegoSerialTokenizer tok = new CegoSerialTokenizer("3@sdt@-@1@1@4@JDBC@11@COMMIT_MODE@1@n@-@4@bool@1@1@1@1@4@true");
		
		while ( tok.hasMoreTokens() )
		{
			System.out.println("Detected token " + tok.nextToken());
		}		
		*/
		
		int i = 0;
		
		while ( i < args.length ) 
		{
			StringTokenizer st = new StringTokenizer(args[i], " ");
			
			String arg = st.nextToken();
			
			if ( arg.equals("-url") )
			{
				String val = st.nextToken();
				_dbUrl=val;
			}
			else if ( arg.equals("-user") )
			{
				String val = st.nextToken();
				_dbUser=val;
			}
			else if ( arg.equals("-pwd") )
			{				
				String val = st.nextToken();
				_dbPwd=val;
			}
			else if ( arg.equals("-testConnection") )
			{
				_testConnection = true;
			}
			else if ( arg.equals("-testBasic") )
			{
				_testBasic = true;
			}
			else if ( arg.equals("-testMultiThread") )
			{
				_testMultiThread = true;
			}
			else if ( arg.equals("-testBlob") )
			{
				_testBlob = true;
			}
			else if ( arg.equals("-testClob") )
			{
				_testClob = true;
			}
			else if ( arg.equals("-testMeta") )
			{
				_testMeta = true;
			}
			else if ( arg.equals("-testCustom") )
			{
				_testCustom = true;
			}
			
			else if ( arg.equals("-blobin") )
			{
				String val = st.nextToken();
				_blobIn=val;
			}
			else if ( arg.equals("-blobout") )
			{
				String val = st.nextToken();
				_blobOut=val;
			}
			else if ( arg.equals("-version") )
			{
				System.out.println(Constant.JDBC_MAJORVERSION + "." + Constant.JDBC_MINORVERSION + "." + Constant.JDBC_PATCHVERSION);
				return;
			}
			else 
			{
				System.out.println("Invalid option " + arg + ", valid options are :" +
						"       -url <url>\n" +
						"       -user <user>\n" +
						"       -pwd <pwd>\n" +
						"       -blobtest\n" +
						"       -blobin <blobfile>\n" +
						"       -blobout <blobfile>\n");
				return;
			}
			i++;
		}
		
		
		try {
			
			Class.forName( "de.lemkeit.cegojdbc.CegoDriver" ) ;
			
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
				
		System.out.println("Searching driver for " + _dbUrl);
		Driver drv = DriverManager.getDriver( _dbUrl );


		
		/*
		Properties info = new Properties();
		info.setProperty("user", _dbUser);
		info.setProperty("password", _dbPwd);
		*/
		
		
		try 
		{					

			if ( _testConnection )
			{
				 // connectionTest();
				decimalInsertTest();
			}
			
			if ( _testMultiThread )
			{
				DriverTest dt = new DriverTest();
				dt.multiThreadTest();
			}
			
			// clobTest();

			if ( _testBasic )
			{
				System.out.println();
				System.out.println("Performing basic tests");
				System.out.println("======================");

				// basicCreateTest();
				basicInsertTest();

				// basicSelectTest();

				// clobGetTest1();
				// clobGetTest2();
				

				// basicSelectTest();
				// basicProcTest();
				// basicDropTest();

			}			
			
			
			if ( _testBlob == true)
			{
				blobPutTest();
				blobGetTest();
			}

			if ( _testClob == true)
			{
				
				// clobPutTest1();
				// clobPutTest2();
				clobPutTest3();
				// clobPutTest4();
				
				// clobGetTest1();
				clobGetTest2();
			}
			
			if ( _testMeta )
			{
				basicMetaTest(); 
			}
			
			
			if ( _testCustom )
			{
				customTest();
				customTest();
				customTest();
				
			}
			

			if ( _testNested )
			{
				nestedTest();
			}
			
						
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	
	}

	public static void connectionTest() throws SQLException
	{

		try
		{

			System.out.print("Connection test ... ");
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );

			System.out.println("ok");

			System.out.println("DBName ... " + con.getMetaData().getDatabaseProductName());
			System.out.println("DBVersion ... " + con.getMetaData().getDatabaseProductVersion());
			System.out.println("DriverVersion ... " + con.getMetaData().getDriverVersion());
			
			boolean isAutoCommit = con.getAutoCommit();
			
			con.setAutoCommit(true);
			
			PreparedStatement s = con.prepareStatement("jdbc commitmode");
			ResultSet rs = s.executeQuery();
			while ( rs.next() )
			{
				String cm = rs.getString(1);
				
				System.out.println("Got Commit Mode :  <" + cm + ">");
			}
			rs.close();
			s.close();
			
			/*
			System.out.println("... MajorVersion=" + con.getMetaData().getDatabaseMajorVersion());
			System.out.println("... MinorVersion=" + con.getMetaData().getDatabaseMinorVersion());

			System.out.println("... JDBCMajorVersion=" + con.getMetaData().getJDBCMajorVersion());
			System.out.println("... JDBCMinorVersion=" + con.getMetaData().getJDBCMinorVersion());
			 */
								
			
			con.close();

		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}						
	}
	
	public void multiThreadTest() throws SQLException
	{		
		
		try
		{
			System.out.println("Creating connection list");
			_conList = new LinkedList<Connection>();
			for ( int i=0; i<25; i++)
			{
				Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
				_conList.add(con);
			}
			
			DBThread[] dbtArray;
			
			dbtArray = new DBThread[MAXTHREADNUM];
			
			for ( int i=0; i< MAXTHREADNUM; i++)
			{
				dbtArray[i] = new DBThread(MAXTHREADOP);
				dbtArray[i].start();
			}
			
			// dbt.start();

			
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}						

	}
	
	
	public static void basicMetaTest() throws SQLException
	{

		try
		{

			System.out.print("Meta data test ... ");
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );

			
			String catalog="catalog";
			String ts="sysmt";
			String procpattern="PPP";
			ResultSet pp = con.getMetaData().getProcedures(catalog, ts, procpattern);
			while ( pp.next() )
			{
				// System.out.println("proc1=" + pp.getString(1));
				// System.out.println("proc2=" + pp.getString(2));
				// System.out.println("proc3=" + pp.getString(3));
			}
			
			ResultSet tt = con.getMetaData().getTableTypes();
			
			while ( tt.next() )
			{
				// System.out.println("TT=" + tt.getString(1));
			}

			ResultSet ti = con.getMetaData().getTypeInfo();
			
			while ( ti.next() )
			{
				// System.out.println("TI=" + ti.getString(1));
			}

			// retrieve table and views
			// ResultSet tj = con.getMetaData().getTables(catalog,ts, null, new String[] { "TABLE", "VIEW" });
			
			// retrieve views
			ResultSet tj = con.getMetaData().getTables(catalog,ts, null, new String[] { "VIEW" });
			
			while ( tj.next() )
			{
				System.out.println("Object=" + tj.getString(3) + " " + tj.getString(4));
			}

			con.close();
			System.out.println("ok");

		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}						
	}

	public static void basicInsertTest() throws SQLException
	{
		System.out.print("Basic insert ... ");

		String save = "Error message: Field 'Responsible_x0020_ContactXXX' is not recognized\n"
				+ "\n"
				+ "POST https://graph.microsoft.com/v1.0/sites/corpdir.sharepoint.com,e0d728b1-0c57-446d-a42b-6889ad5547cf,4045af8c-a0a0-4bc2-be9e-2114131a0e2c/lists/ad54fa31-6fd7-4fa7-8c65-0580b120f281/items\n"
				+ "SdkVersion : graph-java/v5.77.0\n"
				+ "SdkVersion : graph-java/v5.77.0\n"
				+ "[...]\n"
				+ "\n"
				+ "400 : \n"
				+ "[...]";
		
		String save2 = "Error message: Field 'Responsible_x0020_ContactXXX' is not recognized"
				+ "POST https://graph.microsoft.com/v1.0/sites/corpdir.sharepoint.com,e0d728b1-0c57-446d-a42b-6889ad5547cf,";
		
		String s = "Error message: Field ''Responsible_x0020_ContactXXX is not recognized''"
				+ "POST https://graph.microsoft.com/v1.0/sites/corpdir.sharepoint.com,e0d728b1-0c57-446d-a42b-6889ad5547cf,";
		
		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
			PreparedStatement stmt = con.prepareStatement("insert into t1 ( a, b ) values ( ?, ?)");
			stmt.setInt(1,  1);
			stmt.setString(2, s);
			stmt.executeUpdate();
			
			// con.createStatement().executeUpdate("drop table t1;");
			con.close();
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}

	public static void customTest() throws SQLException
	{
	
		
		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
			
			PreparedStatement ps = con.prepareStatement("select nextPropRequest() as scid");

			boolean moreRequest = true;
			
			while ( moreRequest ) 
			{
				System.out.println("More requests ..");
				
				ResultSet rs = ps.executeQuery();
				
				int scid = 0;
				
				if ( rs.next() )
				{

					scid = rs.getInt(1);					

					if ( rs.wasNull() == false)
					{

						System.out.println("Retrieved scid = " + scid);	
					}
					else
					{
						System.out.println("RS was null");	

						moreRequest = false;
					}
				}
				else
				{
					moreRequest = false;
				}
				rs.close();
			}
			ps.close();
			
			System.out.println("Setting to obsolete ..");
			
			
			con.createStatement().executeUpdate("update sysmt_calsync set status = 'Obsolete'");
			
			
			
			ps = con.prepareStatement("select nextPropDelete() as scid");

			moreRequest = true;
			
			while ( moreRequest ) 
			{
				System.out.println("More delete requests ..");
				
				ResultSet rs = ps.executeQuery();
				
				int scid = 0;
				
				// ps.getResultSet();
				
				if ( rs.next() )
				{

					scid = rs.getInt(1);					

					if ( rs.wasNull() == false)
					{

						System.out.println("Retrieved scid = " + scid);	
					}
					else
					{
						System.out.println("RS was null");	

						moreRequest = false;
					}
				}
				else
				{
					moreRequest = false;
				}
				rs.close();
			}
			ps.close();
			
	
			
			con.close();
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}

	public static void clobGetTest1() throws SQLException
	{
		System.out.println("Clob get test ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
						
			PreparedStatement s = con.prepareStatement("select a from clobtab");
			ResultSet rs = s.executeQuery();
			while ( rs.next() )
			{
				Clob c = rs.getClob(1);
				String clobString = clobToString(c);
				
				System.out.println("Got clob of len " + clobString.length() + " Value :  <" + clobString + ">");
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}
	}
	
	private static String clobToString(Clob data) 
	{
	    StringBuilder sb = new StringBuilder();
	    try 
	    {
	        Reader reader = data.getCharacterStream();
	        BufferedReader br = new BufferedReader(reader);

	        String line;
	        while(null != (line = br.readLine())) {
	            sb.append(line);
	        }
	        br.close();
	    }
	    catch (SQLException e) 
	    {
	    		e.printStackTrace();
	    } 
	    catch (IOException e) 
	    {
	    		e.printStackTrace();
	    }
	    return sb.toString();
	}

	public static void clobGetTest2() throws SQLException
	{
		System.out.println("Clob get test 2 ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
			long startTime = System.currentTimeMillis();
			
			ResultSet rs = con.createStatement().executeQuery("select clob2str(a) from clobtab");

			int numClob=0;

			while ( rs.next() )
			{
				String clobValue = rs.getString(1);
				
				numClob++;
				System.out.println("Got clob of len " + clobValue.length() + " " + clobValue);
			}
			
			long stopTime = System.currentTimeMillis();
			long elapsedTime = stopTime - startTime;
			System.out.println(numClob + " clobs retrieved in => " + elapsedTime / 1000 + " sec " + elapsedTime % 1000 + " msec");

		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}
	}

	public static void clobPutTest1() throws SQLException
	{
		System.out.print("Clob put test 1 ... ");

		
		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
						
			PreparedStatement s = con.prepareStatement("insert into clobtab values ( ? )");
				
			String clobString ="THIS IS CLOB 1";
						
			s.setString(1, clobString);
			
			System.out.println("Executing  ... ");
			s.execute();
			System.out.println("Execute done");

			s.close();
			con.close();
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
	}

	public static void clobPutTest2() throws SQLException
	{
		System.out.print("Clob put test 2 ... ");

		
		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
						
			PreparedStatement s = con.prepareStatement("insert into clobtab values ( ? )");
				
			String clobString = "THIS IS CLOB 2";
			
			char[] stringArray = new char[10];
			stringArray[0]='a';
			stringArray[1]='b';
			stringArray[2]='c';
			stringArray[3]=0;
			
			
			CegoClob clob = new CegoClob(stringArray, 3);
			s.setClob(1, clob);
						
			System.out.print("Executing  ... ");
			s.execute();
			System.out.print("Execute done");


			s.close();
			con.close();

			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
	}

	public static void clobPutTest3() throws SQLException
	{
		System.out.print("Clob put test 3 ... ");

		
		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
						
			PreparedStatement s = con.prepareStatement("insert into clobtab values ( ? )");
				
			String clobString ="THIS IS CLOB 3";
			
			s.setAsciiStream(1, new ByteArrayInputStream(clobString.getBytes(StandardCharsets.UTF_8)));
						
			System.out.print("Executing  ... ");
			s.execute();
			System.out.print("Execute done");


			s.close();
			con.close();

			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
	}

	public static void clobPutTest4() throws SQLException
	{
		System.out.print("Clob put test 4 ... ");

		
		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
						
			PreparedStatement s = con.prepareStatement("insert into clobtab values ( ? )");
				
			String clobString ="THIS IS CLOB 4";
	
			Reader r = new StringReader(clobString);
			
			s.setClob(1, r);
			
			System.out.print("Executing  ... ");
			s.execute();
			System.out.print("Execute done");

			s.close();
			con.close();

			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
	}
		
	public static void blobPutTest() throws SQLException
	{
		System.out.print("Blob put test ... ");

		String blobString ="THIS IS THE BLOB STRING XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXX";
		

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
			
			// InputStream stream = new ByteArrayInputStream(blobString.getBytes());
			
			
			// CallableStatement cs = con.prepareCall("{? = call addBlob(?)}");

			// cs.registerOutParameter(1, java.sql.Types.INTEGER);
			
			// cs.setBinaryStream(2, stream);

			// cs.setBlob(3, new CegoBlob(blobString.getBytes()));
			
			/*
			System.out.println("Setting binary Stream");
			s.setBinaryStream(1, is, blobLen);
			System.out.println("Stream set");
			*/


			
			
			PreparedStatement s = con.prepareStatement("insert into btab values ( ? )");
				
			
			File f = new File("/tmp/blob");
			long blobLen = f.length();
			FileInputStream fs = new FileInputStream("/tmp/blob");
			InputStream is = new BufferedInputStream(fs);

			s.setBinaryStream(1, is, blobLen);
			System.out.print("Executing  ... ");
			s.execute();
			System.out.print("Execute done");


			s.close();
			con.close();

			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}

	
	public static void blobGetTest() throws SQLException
	{
		System.out.print("Blob get test ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
			
			Statement stmt = con.createStatement();
			stmt.execute("select a from btab;");
			
			ResultSet rs = stmt.getResultSet();
			
			while ( rs.next() ) 
			{
				Blob b = rs.getBlob(1);
				
				System.out.println("Length is " + b.length());
				String s = new String(b.getBytes(1, (int)b.length()));
				
				System.out.println("Blob is <" + s + ">");
				/*
				InputStream is = rs.getBinaryStream(1);
				
				File f=new File(_blobOut);
				OutputStream out=new FileOutputStream(f);
				byte buf[]=new byte[1024];
				int len;
				while((len=is.read(buf))>0)
				{
					// System.out.println("Writing " + len);
					out.write(buf,0,len);
				}
				out.close();
				is.close();
				*/
				
			}

			stmt.close();
			con.close();
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}
	
	public static void basicSelectTest() throws SQLException
	{
		System.out.print("Basic select test ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
					
	
			// Statement stmt = con.createStatement();
			// stmt.execute("select a, b from t2;");
			// stmt.close();

			PreparedStatement stmt = con.prepareStatement("select a from t1");

			stmt.execute();

			ResultSet rs = stmt.getResultSet();


			while ( rs.next() )
			{				
				int intVal = rs.getInt(1);
				int intVal2 = rs.getInt(1);
				
				System.out.println("Int = " + intVal);
				
			}

			rs.close();
			stmt.close();

			/*
			int c=0;
			while ( rs.next() ) 
			{
				// int a = rs.getInt(1);
				String b = rs.getString(2);
				c++;

				 System.out.println("ROW DATA : " + a + " " + b);
			}
			System.out.println("Read " + c + " rows");


			stmt.close();
			con.close();
			*/
			
			con.close();

			
			// System.out.println("elapsed time => " + elapsedTime / 1000 + " sec " + elapsedTime % 1000 + " msec");
			
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}


	public static void basicProcTest() throws SQLException
	{
		System.out.print("Basic procedure test ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );

			CallableStatement cs1 = con.prepareCall("{? = call checkInOut(?,?)}");

			cs1.registerOutParameter(1, java.sql.Types.INTEGER);
			cs1.setInt(2, 999);
			cs1.registerOutParameter(3, java.sql.Types.VARCHAR);


			ResultSet rs = cs1.executeQuery();

			int o1 = cs1.getInt(1);
			String o2 = cs1.getString(2);

			// System.out.println("Out=" + o1);
			// System.out.println("Out=" + o2);

			
			if ( o1 != 999 )
			{
				throw new Exception("Wrong result");
			}
			if ( ! o2.equals("Hello World"))
			{
				throw new Exception("Wrong result");
			}


			rs.close();
			cs1.close();
			con.close();

			System.out.println("ok");

		}
		catch ( Exception e )
		{
			System.out.println("failed");
		}
	}
	
	public static void basicCreateTest() throws SQLException
	{
		System.out.print("Basic create ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			con.createStatement().executeUpdate("drop if exists table t1;");
			con.createStatement().executeUpdate("create table t1 ( a int, b string(30));");

			
			con.createStatement().executeUpdate("drop if exists table btab;");
			con.createStatement().executeUpdate("create table btab ( a blob);");

			con.createStatement().executeUpdate("drop if exists procedure checkIn;");
			con.createStatement().executeUpdate("create procedure checkIn ( v1 in int, v2 in string(30) ) " +
					"begin " +
					"   insert into t1 values ( :v1, :v2);" +
					"   return; " +
					"end;");

			
			con.createStatement().executeUpdate("drop if exists procedure checkInOut;");
			con.createStatement().executeUpdate("create procedure checkInOut ( v1 in int, v2 out string(30) ) return int " +
					"begin " +
					"   :v2 = 'Hello World'; " +
					"   return :v1; " +
					"end;");

			con.close();
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}

	public static void basicDropTest() throws SQLException
	{
		System.out.print("Basic drop ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			con.createStatement().executeUpdate("drop if exists table t1;");
			con.createStatement().executeUpdate("drop if exists table btab;");
			con.createStatement().executeUpdate("drop if exists procedure checkIn;");
			con.createStatement().executeUpdate("drop if exists procedure checkInOut;");
			con.close();
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}

	
	public static void nestedTest() throws SQLException
	{
		System.out.print("Nested test ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );

			
			con.createStatement().executeUpdate("drop if exists table t2;");
			con.createStatement().executeUpdate("create table t2 ( a int, b string(30));");

			
			long startTime = System.currentTimeMillis();
			
			Statement stmt = con.createStatement();
			stmt.execute("select a, b from t1;");
			
			
			ResultSet rs = stmt.getResultSet();

			
			int c=0;
			while ( rs.next() ) 
			{
				int i = rs.getInt(1);
				String s = rs.getString(2);

			
				// System.out.println("Prepare nested statement");
				
				PreparedStatement stmt2 = con.prepareStatement("insert into t2 values ( ?, ? );");
				
				stmt2.setInt(1, i);
				stmt2.setString(2, s);
				
				// System.out.println("Executing nested stmt ..");
				stmt2.execute();
				
				stmt2.close();

				c++;
				// System.out.println(i + " " + s);
			}

			stmt.close();
			con.close();
			
		
			long stopTime = System.currentTimeMillis();
			long elapsedTime = stopTime - startTime;
			// System.out.println(c + " rows => " + elapsedTime / 1000 + "." + elapsedTime % 1000 + " sec");
			
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}
	
	public static void clobTest() throws SQLException
	{
		System.out.print("Clob test ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );

			PreparedStatement s = con.prepareStatement("insert into t1 values ( ? )");
							
			File f = new File("/tmp/clob");
			long clobLen = f.length();
			FileInputStream fs = new FileInputStream("/tmp/clob");
			InputStream is = new BufferedInputStream(fs);

			s.setAsciiStream(1, is, clobLen);
			System.out.print("Executing  ... ");
			s.execute();
			System.out.print("Execute done");
			
			s.setString(1, "String2Cob");
			System.out.print("Executing  ... ");
			s.execute();
			System.out.print("Execute done");

			s.close();
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}

	public static void decimalInsertTest() throws SQLException
	{
		System.out.print("Decimal insert ... ");

		try
		{
			Connection con = DriverManager.getConnection(_dbUrl, _dbUser, _dbPwd );
			
			PreparedStatement ps = con.prepareStatement("insert into t1 values ( ?, ?)");
			
			ps.setBigDecimal(1, new BigDecimal(4711));
			ps.setBigDecimal(2, new BigDecimal(4712));
			
			ps.executeUpdate();

			ps.close();

			con.close();
			
			System.out.println("ok");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			System.out.println("failed");
		}		
		
	}


}
