///////////////////////////////////////////////////////////////////////////////
//                                                         
// GetOpt.cc
// ---------
// GetOpt class implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: GetOpt
// 
// Description: Handling command line arguments
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// POSIX INCLUDES
#include <string.h>

// LFC INCLUDES
#include "Chain.h"
#include "Exception.h"
#include "GetOpt.h"

GetOpt::GetOpt(unsigned argc, char** argv, char* pF)
{
    _argc = argc;
    _argv = argv;
    _pF = pF;
}

GetOpt::~GetOpt()
{
}

unsigned GetOpt::firstOpt()
{
    _optPos = 1;
    return parseOpt();
}

unsigned GetOpt::nextOpt()
{
    _optPos++;
    return parseOpt();
}

unsigned GetOpt::parseOpt()
{
    if (_optPos < _argc )
    {
	if (strlen(_argv[_optPos]) == 2 && _argv[_optPos][0] == '-')
	{
	    unsigned c = _argv[_optPos][1];
	    if ( isValidOption(c) )
	    {
		return c;    
	    }
	    else
	    {
		Chain msg = Chain("Invalid option -") + Chain((char)c);
		throw Exception(EXLOC, msg);
	    }
	}
	else
	{
	    Chain msg = Chain("Invalid option ") + Chain(_argv[_optPos]);
	    throw Exception(EXLOC, msg);
	}
    }
    else
    {
	return 0;
    }
}

bool GetOpt::isValidOption(unsigned c)
{
    char *pF = _pF;
    while (*pF)
    {
	if (*pF == c)
	{
	    pF++;
	    if (*pF != 0)
	    {
		if (*pF == ':')
		{
		    _optPos++;
		    _optArg = _argv[_optPos];
		}
	    }
	    return true;
	}
	else
	{
	    pF++;
	}   
    }
    return false;    
}

char* GetOpt::getArg()
{
    return _optArg;
}
