#ifndef _REPLACER_H_INCLUDED_
#define _REPLACER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Replacer.h
// ----------
// Replacer class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: Replacer 
// 
// Description: Replacer utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////


// INCLUDES
#include <iostream>
#include <sys/types.h>
#include <regex.h>

class Replacer {

public:
    
    Replacer(const Chain& exp = Chain(), const Chain& replace = Chain());
    ~Replacer();

    void set(const Chain& expr, const Chain& replace);
    const Chain& getExpr() const;
    const Chain& getReplace() const;

    void prepare();

    unsigned long replace(const Chain& src, Chain& target);
    
private:
    
    Chain _expr;
    Chain _replace;
    regex_t *_pRE;
    size_t _nmatch;
    size_t _br;
    regmatch_t* _m;
};
#endif
