///////////////////////////////////////////////////////////////////////////////
//                                                         
// BigDecTest.cc
// -------------
// BigDecimal class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////


#include "../src/Exception.h"
#include "../src/BigDecimal.h"

int main(int argc, char **argv)
{
    int numCheck = 28;
    int checkCount = 1;
    
    try {

	if ( 0 )
	{
	    
	    // 23
	    BigDecimal t1("0.11");
	    BigDecimal t2("4.89");
	    
	    BigDecimal t3 = t2.mul(t1);
	    
	    cout << t3.toChain() << endl;
	    if ( t3.toChain() == Chain("0.5379") )
		cout << "ok " << checkCount << " - mul with no rounding" << endl;
	    else
		cout << "not ok " << checkCount << " - mul with no rounding" << endl;
	    checkCount++;
	    
	    
	    // 24
	    if (  t3.scaleTo(2).toChain() == Chain("0.53") )
		cout << "ok " << checkCount << " - mul with default rounding" << endl;
	    else
		cout << "not ok " << checkCount << " - mul with default rounding" << endl;
	    checkCount++;

	    exit(0);
	    
	}
	
	
	if ( 0 )
	{
	    // 20
	    BigDecimal dxx1("119.00");
	    BigDecimal dxx2("100.00");
	    
	    BigDecimal dxx3 = dxx1.div(dxx2);	
	    
	    cout << dxx3.toChain() << endl;
	    
	    if (  dxx3.toChain() == Chain("1.19") )
		cout << "ok " << checkCount << " - div <" << endl;
	    else
		cout << "not ok " << checkCount << " - div < " << endl;
	    checkCount++;

	    exit (0);
	}

	
	if ( 0 )
	{
	// 18
	// 11
	    BigDecimal xx1("3.451");
	    BigDecimal xx2("4");
	    
	    BigDecimal dcheck = xx1.sub(xx2);
	    
	    
	    cout << dcheck.toChain() << endl;
	    if (  dcheck.toChain() == Chain("-0.549") )
		cout << "ok " << checkCount << " - sub" << endl;
	    else
		cout << "not ok " << checkCount << " - sub" << endl;
	    checkCount++;

	    exit(0);
	}
	
	//////////////
	
	cout << "1.." << numCheck << endl;

	// 1
	BigDecimal d01(".97");
	if ( d01.toChain() == Chain("0.97") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;


	// 2
	BigDecimal dx("23.4800");
	// cout << dx.toChain() << endl;
	if ( dx.toChain() == Chain("23.4800") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;


	//3
	BigDecimal d021("0");
	// cout << d021.toChain() << endl;
	if ( d021.toChain() == Chain("0.0") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;


	// 4
	BigDecimal d022("0.0");
	// cout << d022.toChain() << endl;
	if ( d022.toChain() == Chain("0.0") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	// 5
	BigDecimal d023("0.000");
	// cout << d023.toChain() << endl;
	if ( d023.toChain() == Chain("0.000") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	// 6
	BigDecimal d024("0000.0");
	// cout << d024.toChain() << endl;
	if ( d024.toChain() == Chain("0.0") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;
	
	// 7
	BigDecimal d03("00004.45");	
	if ( d03.toChain() == Chain("4.45") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	// 8
	BigDecimal d04("00004.450000");
	// cout << d04.toChain() << endl;
	if ( d04.toChain() == Chain("4.450000") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;


	// 9
	BigDecimal d05("00000.06780000");
	
	if ( d05.toChain() == Chain("0.06780000") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	// 10
	BigDecimal d06("119.00");	
	if ( d06.toChain() == Chain("119.00") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;


	// 11
	BigDecimal d1("179.97");
	BigDecimal d2("120.11");
	BigDecimal d3("13.0");
	BigDecimal d4("4.987");      
	BigDecimal d5("16.987");
	
	if ( d2 < d1 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;


	// 12
	if ( d4 < d3 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;


	// 13
	if ( d3 < d2 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;

	// 14
	if ( d3 < d5 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;

	// 15
	BigDecimal dadd = d3.add(d4);
	if (  dadd.toChain() == Chain("17.987") )
	    cout << "ok " << checkCount << " - add" << endl;
	else
	    cout << "not ok " << checkCount << " - add" << endl;
	checkCount++;

	// 16
	BigDecimal f1("5.0000");
	BigDecimal f2("0.0");
	BigDecimal ddiv = f2.div(f1);

	// cout <<  "XXXXXXXX" << ddiv.toChain() << endl;
	
	if (  ddiv.toChain() == Chain("0.0") )
	    cout << "ok " << checkCount << " - div" << endl;
	else
	    cout << "not ok " << checkCount << " - div" << endl;
	checkCount++;


	// eval term div (fixed)
	// eval facor div (fixed)-26.061528

	// 17
	BigDecimal f1n("-26.362528");
	BigDecimal f2n("-2606.152800");
	BigDecimal ddivn = f2n.div(f1n);

	// cout << ddivn << endl;
	
	if (  ddivn.toChain() == Chain("98.858227") )
	    cout << "ok " << checkCount << " - div" << endl;
	else
	    cout << "not ok " << checkCount << " - div" << endl;
	checkCount++;


	// 18
	BigDecimal dsub = d1.sub(d2);
	
	if (  dsub.toChain() == Chain("59.86") )
	    cout << "ok " << checkCount << " - sub" << endl;
	else
	    cout << "not ok " << checkCount << " - sub" << endl;
	checkCount++;


	// 19
	BigDecimal c1("12.4");
	BigDecimal c2("12.44234");
	
	if (  c1 < c2 )
	    cout << "ok " << checkCount << " - op <" << endl;
	else
	    cout << "not ok " << checkCount << " - op < " << endl;
	checkCount++;

	// 20
	BigDecimal dxx1("119.00");
	BigDecimal dxx2("100.00");

	BigDecimal dxx3 = dxx1.div(dxx2);	

	// cout << dxx3.toChain() << endl;
	
	if (  dxx3.toChain() == Chain("1.19") )
	    cout << "ok " << checkCount << " - div <" << endl;
	else
	    cout << "not ok " << checkCount << " - div < " << endl;
	checkCount++;


	// 21
	BigDecimal dcomp1("0.001");
	BigDecimal dcomp2("0.001000");

	BigDecimal dzero1("-0.000");
	BigDecimal dzero2("0.000000");
	
	if (  dcomp1 == dcomp2 && dzero1 == dzero2 )
	    cout << "ok " << checkCount << " - comp check" << endl;
	else
	    cout << "not ok " << checkCount << " - comp check " << endl;
	checkCount++;	

	
	// 22
	BigDecimal scaleSource("1.34667");
	BigDecimal scaleTarget = scaleSource.scaleTo(2, BigDecimal::UP);


	if (  scaleTarget.toChain() == Chain("1.35") )
	    cout << "ok " << checkCount << " - scale check" << endl;
	else
	    cout << "not ok " << checkCount << " - scale check " << endl;
	checkCount++;	

	// 23
	BigDecimal t1("0.11");
	BigDecimal t2("4.89");
	BigDecimal t3 = t2.mul(t1);
	       
	if ( t3.toChain() == Chain("0.5379") )
	    cout << "ok " << checkCount << " - mul with no rounding" << endl;
	else
	    cout << "not ok " << checkCount << " - mul with no rounding" << endl;
	checkCount++;


	// 24
	if (  t3.scaleTo(2).toChain() == Chain("0.53") )
	    cout << "ok " << checkCount << " - mul with default rounding" << endl;
	else
	    cout << "not ok " << checkCount << " - mul with default rounding" << endl;
	checkCount++;


	// 25
	BigDecimal x1("0.11");
	BigDecimal x2("4.87");
	
	BigDecimal x3 = x2.mul(x1);
	
	
	if (  x3.scaleTo(2, BigDecimal::HALFUP).toChain() == Chain("0.54") )
	    cout << "ok " << checkCount << " - mul with half up rounding" << endl;
	else
	    cout << "not ok " << checkCount << " - mul with half up rounding" << endl;
	checkCount++;


	// 26

	BigDecimal y1("1.112");
	BigDecimal y2("1.87");
	
	BigDecimal y3 = y1.mul(y2);

	if ( y1.mul(y2).scaleTo(3, BigDecimal::HALFDOWN) == Chain("2.079") )
	    cout << "ok " << checkCount << " - mul with half down rounding" << endl;
	else
	    cout << "not ok " << checkCount << " - mul with half down rounding" << endl;
	checkCount++;

	// 27

	BigDecimal n1("0.01304");
	
	// cout << "N1=" << n1.toChain() << endl;
	
	BigDecimal n2("0.00");


	// cout << "N2=" << n2.toChain() << endl;
	// cout << "N2=" << n2.scaleTo(1).toChain() << endl;
	// cout << "N2=" << n2.scaleTo(5).toChain() << endl;
	
	int decDim=2;
	
	BigDecimal n3 = n1.mul(n2);

	// cout << "XXN3=" << n3.toChain() << endl;
	
	if ( n3.toChain() == Chain("0.0000000") )
	    cout << "ok " << checkCount << " - zero scaling" << endl;
	else
	    cout << "not ok " << checkCount << " - zero scaling" << endl;
	checkCount++;

	
	// cout << "Scaling : " << n3.toChain() << endl;
	BigDecimal n4 = n3.scaleTo(decDim, BigDecimal::DOWN);

	if ( n4.toChain() == Chain("0.00") )
	    cout << "ok " << checkCount << " - zero scaling" << endl;
	else
	    cout << "not ok " << checkCount << " - zero scaling" << endl;
	checkCount++;


	exit(0);

	
    }
    catch (Exception e)
    {

	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }

    return 0;

}

