// FileTest.cc
// -------------
// file class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/File.h"


int main(int argc, char **argv)
{
    
    /*
    File stdIn(File::IN);
    Chain l;

    cout << "Checking for data .." << endl;
    if ( stdIn.hasData(100) )
    {
	cout << "Data available ..." << endl;
	cout.flush();
	
	while ( stdIn.readLine(l) )
	{
	    cout << "Read : " << l << endl;
	}
    }
    
    return 0;

    */
    
    
    /*

      additional test for stdout

      File stdOut(File::OUT);
      Chain l("This is the line\n");
      stdOut.writeChain(l);
      stdOut.writeChain(l);
      stdOut.writeChain(l);

    */
    
    int numCheck = 5;
    int checkCount = 1;
    
    try
    {
	cout << "1.." << numCheck << endl;

	File testFile(Chain("testFile"));
	
	testFile.exists();
	testFile.open(File::WRITE);
       
	for (int i = 0; i<10; i++)
	{
	    testFile.writeChain("hello world\n");	  
	    testFile << "Hello World" << 42 << "\n";
	}

	testFile.flush();
	cout << "ok " << checkCount << " - flush file" << endl;
	checkCount++;
	
	testFile.close();
	cout << "ok " << checkCount << " - write file" << endl;
	checkCount++;
	
	File testFile2(Chain("testFile"));
	
	testFile2.open(File::READ);
	testFile2.Size();

	Chain line;
	
	while (testFile2.readLine(line))
	{
	    // cout << "<<<" << line << ">>>" << endl;
	}
	
	testFile2.close();
	
	cout << "ok " << checkCount << " - read file" << endl;
	checkCount++;

	File copyFile(Chain("copyFile"));
	copyFile = testFile2;
	cout << "ok " << checkCount << " - copy file" << endl;
	checkCount++;

	
	copyFile.rename(Chain("renameFile"));
	cout << "ok " << checkCount << " - rename file" << endl;
	checkCount++;

    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;
    
}
  

