///////////////////////////////////////////////////////////////////////////////
//                                                         
// ReplaceTest.cc
// --------------
// ReplaceTest class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2004 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Replacer.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <regex.h>

int main(int argc, char **argv)
{    
    int numCheck = 11;
    int checkCount = 1;
    
    try
    {
	cout << "1.." << numCheck << endl;

	
	//  #1 - Double replacement with first match
	{
	    Chain pattern("([a-zA-Z0-9]*).*");
	    Chain replace("$1");
	    
	    Replacer rep(pattern, replace);
	    
	    rep.prepare();
	    
	    Chain target;
	    
	    Chain str1("AlphaBeta123#hugokommt");
	    
	    // unsigned long nmatch =
	    rep.replace(str1, target);

	    // cout << "nmatch = " << nmatch << endl;

	    // cout << "target = " << target << endl;
	    
	    if ( target == Chain("AlphaBeta123") )
		cout << "ok " << checkCount << " - First replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - First replace test" << endl;
	    checkCount++;
	    
	}

	
	//  #2 - Double replacement with first match
	{
	    Chain pattern1("(Hux)");
	    Chain replace1("Alpha$1X$1Beta");
	    
	    Replacer rep(pattern1, replace1);
	    
	    rep.prepare();
	    
	    Chain target;
	    
	    Chain str1("MyPre:HuxBBB");

	    // unsigned long nmatch =
	    rep.replace(str1, target);

	    if ( target == Chain("MyPre:AlphaHuxXHuxBetaBBB") )
		cout << "ok " << checkCount << " - First replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - First replace test" << endl;
	    checkCount++;
	}

	//  #3 - Replacement with no match reference
	{
	    Chain pattern1("(Hux)");
	    Chain replace1("AlphaBeta");
	    
	    Replacer rep(pattern1, replace1);
	    
	    rep.prepare();
	    
	    Chain target;
	    
	    Chain str1("MyPre:HuxBBB");

	    // unsigned long  nmatch =
	    rep.replace(str1, target);
	    
	    if ( target == Chain("MyPre:AlphaBetaBBB") )
		cout << "ok " << checkCount << " - Second replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Seond replace test" << endl;
	    checkCount++;
	}

	// #4 - More sophisticated expression with 3 replacements
	{
	
	    Chain pattern1("(A.*)->(B.*)->(G.*a)");
	    Chain replace1("PRE Second=$2 First=$1 Third=$3 POST");
	    
	    Replacer rep(pattern1, replace1);
	    
	    rep.prepare();
	    
	    Chain target;
	    
	    Chain str1("MyPre:AlphaLong->Beta->Gamma:MyPost");
	    
	    // unsigned long nmatch =
	    rep.replace(str1, target);
	    
	    // cout << "Place=" << target << endl;
	    if ( target == Chain("MyPre:PRE Second=Beta First=AlphaLong Third=Gamma POST:MyPost") )
		cout << "ok " << checkCount << " - Third replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Third replace test" << endl;
	    checkCount++;
	    
	}

	// #5 - Sophisticed expression with same replacer and pattern/replace setup
	{	    	   		    
	    Chain str2("MyPre:Alpha->Beta->AlphaGamma:MyPost");
	    Chain pattern2("(A.*)->(B.*)->");
	    Chain replace2("Beta=$2 Alpha1=$1 Alpha2=$2");
	   
	    Replacer rep(pattern2, replace2);

	    // set check
	    rep.set(pattern2, replace2);
	    rep.prepare();
	    
	    Chain target = Chain();
	    // unsigned long  nmatch =
	    rep.replace(str2, target);
	    
	    // cout << "Target=" << target << endl;
	    
	    if ( target == Chain("MyPre:Beta=Beta Alpha1=Alpha Alpha2=BetaAlphaGamma:MyPost") )
		cout << "ok " << checkCount << " - Fourth replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Fourth replace test" << endl;
	    checkCount++;
	}

	// #6 - Same replacer with different source
	{

	    Chain pattern2("(A.*)->(B.*)->");
	    Chain replace2("Beta=$2 Alpha1=$1 Alpha2=$2");	    
	    Replacer rep(pattern2, replace2);
	    rep.prepare();
	    
	    Chain str3("MyPre:AlphaXX->BetaXXX->Gamma:MyPost");

	    
	    Chain target = Chain();
	    // unsigned long nmatch =
	    rep.replace(str3, target);
	    
	    // cout << target << endl;
	    
	    if ( target == Chain("MyPre:Beta=BetaXXX Alpha1=AlphaXX Alpha2=BetaXXXGamma:MyPost") )
		cout << "ok " << checkCount << " - Fifth replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Fifth replace test" << endl;
	    checkCount++;
	}

	// #7 - Decimal to money format conversion
	{
	    Chain amDec("458007663800.93");
	    
	    Chain ap1("([0-9])([0-9][0-9][0-9][.])");
	    Chain ar1("$1.$2");
	    
	    Replacer repx(ap1, ar1);
	    repx.prepare();
	    
	    Chain amTmp;
	    
	    while ( repx.replace(amDec, amTmp) > 0 )
	    {
		amDec = amTmp;
		amTmp=Chain();
	    }
	    
	    Chain ap2("([0-9]*).([0-9][0-9])$");
	    Chain ar2("$1,$2");
	    
	    repx.set(ap2, ar2);
	    repx.prepare();

	    Chain target;
	    
	    target = Chain();
	    repx.replace(amDec, target);	
	    
	    if ( target == Chain("458.007.663.800,93") )
		cout << "ok " << checkCount << " - Sixth replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Sixth replace test" << endl;
	    checkCount++;
	}


	// #8 - replacement with escape sign in replace string
	{
	    
	    Chain pattern1("(Hux)");
	    Chain replace1("Alpha$1$$$1Beta$$");
	    
	    Replacer rep(pattern1, replace1);
	    
	    rep.prepare();
	    
	    Chain target;
	    
	    Chain str1("MyPre:HuxBBB");
	    
	    // unsigned long nmatch =
	    rep.replace(str1, target);

	    // cout << "NMAtch=" << nmatch << endl;
	    // cout << "Place=" << target << endl;


	    if ( target == Chain("MyPre:AlphaHux$HuxBeta$BBB") )
		cout << "ok " << checkCount << " - Seventh replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Seventh replace test" << endl;
	    checkCount++;
	   
	    
	}

	// #9 - multiple replacements with escape token
	{
	    
	    Chain pattern1("(Hux)");
	    Chain replace1("Alpha$1Beta$$");
	    
	    Replacer rep(pattern1, replace1);
	    
	    rep.prepare();
	    
	    Chain target;
	    
	    Chain str1("MyPre:HuxBBBHuxHuxGamma");
	    
	    // unsigned long nmatch =
	    rep.replace(str1, target);

	    // cout << "NMAtch=" << nmatch << endl;
	    // cout << "Place=" << target << endl;


	    if ( target == Chain("MyPre:AlphaHuxBeta$BBBAlphaHuxBeta$AlphaHuxBeta$Gamma") )
		cout << "ok " << checkCount << " - Eight replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Eight replace test" << endl;
	    checkCount++;
	   
	    
	}

	// #10 - Treat zero  len replacements
	{

	    Chain pattern("([X]*)[.]([X]*)");
	    Chain replace("$2.$1");

	    Replacer rep(pattern, replace);
	    
	    rep.prepare();
	    
	    Chain target;
	    
	    Chain str1("Hello.world");

	    // zero len replacements before and after dot
	    // unsigned long nmatch =
	    rep.replace(str1, target);

	    if ( target == Chain("Hello.world") )
		cout << "ok " << checkCount << " - Zero len replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Zero len replace test" << endl;
	    checkCount++;

	    
	}


	// #11 - Range pattern expression wit flip
	{

	    Chain pattern("([a-zA-Z0-9]*)[.]([a-zA-Z0-9]*)");
	    Chain replace("$2.$1");

	    Replacer rep(pattern, replace);
	    
	    rep.prepare();
	    
	    Chain target;
	    
	    Chain str1("HelloWorld.Trash123");

	    // zero len replacements before and after dot
	    // unsigned long nmatch =
	    rep.replace(str1, target);

	    if ( target == Chain("Trash123.HelloWorld") )
		cout << "ok " << checkCount << " - Flip replace test" << endl;
	    else
		cout << "not ok " << checkCount << " - Flip replace test" << endl;
	    checkCount++;

	    exit(0);
	    
	}

	
    }        
    catch (Exception e)
    {
	
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
        return 1;
    }
    
    return 0;   
    
}

