/////////////////////////////////////////////////////////////////////////////// 
// 
// Screen2Test.cc 
// ------------- 
// NG Screen class test module 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017-2022 by Bjoern Lemke 
// 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include "../src/Exception.h" 
#include "../src/Screen.h"
#include "../src/Sleeper.h"

#include <locale.h> 


class MyMessage : public Screen::Message
{
public:
    
    MyMessage(Screen::Panel* pParent, const Chain& title, const Chain& msg) : Screen::Message(pParent) {
	setInfo(title, msg, 3);
    }
    
};

class MyAttr : public Screen::Attribute
{
public:
    
    MyAttr(Screen::Panel* pParent, const Chain& title)
	: Screen::Attribute(pParent, Attribute::OVERLAY) {


	_count = 0;
    }

    bool doRefresh() { return true; };
    
    void refresh() {


	ListT<Chain> attrList1;
	attrList1.Insert(Chain("Count=") + Chain(_count)); 
	attrList1.Insert(Chain("Name=Lemke")); 
	attrList1.Insert(Chain("ZIP=71638"));
	attrList1.Insert(Chain("City=Ludwigsburg"));
      
	ListT<Chain> attrList2;
	attrList2.Insert(Chain("Name=Hugo")); 
	attrList2.Insert(Chain("ZIP=9999"));
	attrList2.Insert(Chain("City=Bumpflingen"));
      
	ListT< ListT<Chain> > masterList;
	masterList.Insert(attrList1);
	masterList.Insert(attrList2);

	ListT<Chain> titleList;
	titleList.Insert(Chain("First"));
	titleList.Insert(Chain("Second"));
	
	setAttrList(titleList, masterList);

	setStatus(Chain("Attribute refresh called ") + Chain(_count));
	
	_count++;
    }

private:

    unsigned _count;

};


class MySelect : public Screen::Select
{
public:

    MySelect(Screen::Panel* pParent, const Chain& title)
	: Screen::Select(pParent) {

	ListT<Chain> items;
	items.Insert(Chain("First=1"));
	items.Insert(Chain("Sec=2"));
	items.Insert(Chain("Third=3"));
	items.Insert(Chain("Fourth=4"));

	setItems(title, items);

	_pAttr = new MyAttr(this, Chain("Select attr check"));
    }
    
    ~MySelect() {
	delete _pAttr;
	    
    }
    
    Screen::Panel* onSelect(unsigned selected) {

	
	unsigned action = getSelectedValue().asUnsigned();
	
	switch ( action )
	{
	case 4:
	{
	    return _pAttr;	     
	}	
	}
	
	setStatus(Chain("Select item ") + Chain(selected) + Chain(" Key =") + getSelectedKey());

	return _pParent;
    }
    
private:


    MyAttr* _pAttr;
};



class MyGrid : public Screen::Grid
{
public:
    
    MyGrid(Screen::Panel* pParent, const Chain& title)
	   : Screen::Grid(pParent) {


	ListT<Chain> gridSchema;
	gridSchema.Insert(Chain("First=l10"));
	gridSchema.Insert(Chain("Second=r20"));
	gridSchema.Insert(Chain("Third=r10"));
	gridSchema.Insert(Chain("Forth=r10"));
	gridSchema.Insert(Chain("Fifth=l10"));

	ListT<Screen::GridColor> colorMap;
	setSchema(title, gridSchema, colorMap, 0);

	_pMsg = new MyMessage(this, Chain("MyTitle"), Chain("XXXX"));
	_pSelect = new MySelect(this, Chain("Sample select"));
	_pSubGrid = new MySubGrid(this);
    }

    ~MyGrid() {
	if ( _pMsg != 0 )
	    delete _pMsg;
	if ( _pSelect )
	    delete _pSelect;
	if ( _pSubGrid )
	    delete _pSubGrid;
    }
       
    Screen::Panel* onSelect(unsigned rowNum) {

	return _pSelect;
    }

    Screen::Panel* onKey(unsigned c, unsigned rowNum) {
	

	if ( c == 'm' )
	{	    
	    _pMsg->setInfo(Chain("Key pressed = ") + Chain(c), Chain("RowNum = ") + Chain(rowNum));
	    return _pMsg;
	}
	else if ( c == 's' )
	{

	    ListT<Chain> items;
	    items.Insert(Chain("First=1"));
	    items.Insert(Chain("Sec=2"));
	    items.Insert(Chain("Third=3"));

	    _pSelect->setItems(Chain("Key pressed = ") + Chain(c) + Chain(" RowNum = ") + Chain(rowNum),
			       items);
	    return _pSelect;
	}
	else if ( c == 'g' )
	{
	    return _pSubGrid;
	}

	return this;
    }

    ListT< ListT<Chain> > getData() {
	return _data;
    }

    void refresh() {


	_data.Empty();
	
	for ( unsigned i=1; i<= 3; i++ )
	{
	    ListT<Chain> row;
	    row.Insert(Chain("Alpha"));
	    row.Insert(Chain("Beta"));
	    row.Insert(Chain("Gamma"));
	    row.Insert(Chain("Epsilon"));

	    row.Insert(Chain("EpsilonXXX"));
	    // row.Insert(Chain(i));
	    
	    _data.Insert(row);
	}

	for ( unsigned i=1; i<= 3; i++ )
	{
	    ListT<Chain> row;
	    row.Insert(Chain("Hu"));
	    row.Insert(Chain("Hoi"));
	    row.Insert(Chain("Hallo"));
	    row.Insert(Chain("Erna"));
	    row.Insert(Chain(i));
	    _data.Insert(row);
	}

	
	_j++;
    }
	

private:


    class MySubGrid : public Screen::Grid
    {
    public:
	
	MySubGrid(Screen::Panel* pParent)
	    : Screen::Grid(pParent) {
	    
	    ListT<Chain> gridSchema;
	    gridSchema.Insert(Chain("XFirst=l10"));
	    gridSchema.Insert(Chain("XSecond=l20"));
	    // gridSchema.Insert(Chain("XThird=10"));
	    // gridSchema.Insert(Chain("XForth=10"));
	    // gridSchema.Insert(Chain("XFifth=10"));
	    
	    ListT<Screen::GridColor> colorMap;
	    setSchema(Chain("Sub Grid"), gridSchema, colorMap, 0);
	    
	}
	
	ListT< ListT<Chain> > getData() {
	    return _data;
	}
	
	void refresh() {
	    
	    
	    _data.Empty();
	    
	    for ( unsigned i=1; i<= 50; i++ )
	    {
		ListT<Chain> row;
		row.Insert(Chain("XXX"));
		// row.Insert(Chain("YYYY"));
		// row.Insert(Chain("YYYY"));
		// row.Insert(Chain("YYYY"));
		row.Insert(Chain(i));
		_data.Insert(row);
	    }
	}
    private:
	ListT< ListT<Chain> > _data;
    };
    
   
    MyMessage* _pMsg;
    MySelect* _pSelect;
    MySubGrid* _pSubGrid;
    ListT< ListT<Chain> > _data;
    unsigned _j;
};

class MyForm : public Screen::Form
{
public:
    
    MyForm(Screen::Panel* pParent)
    : Screen::Form(pParent) {

	ListT<Chain> attrList;
	attrList.Insert(Chain("Str:S:80:Hello")); 
	attrList.Insert(Chain("Number:N:8:4711"));
	attrList.Insert(Chain("Password:P:5"));
	attrList.Insert(Chain("Menu Input:M:10:Beta=B,Alpha=A,Beta=B,Gamma=XXX"));

	setAttrList(Chain("Sample Form"), attrList, 10);
	
	ListT<Chain> valList;

	valList.Insert(Chain("XXX"));
	valList.Insert(Chain("66"));
	valList.Insert(Chain("secret"));
	valList.Insert(Chain("XXX"));
	
	setValueList(valList);
	
    }

    void enter() {
	this->reset();
	// this->clear();
    }
	    
    Screen::Panel* onConfirm(const ListT<Chain>& valList) {
	
	// Chain *pVal = valList.First();
	this->clear();
	return _pParent;
    }

    Screen::Panel* onCancel() {
	
	return _pParent;
    }

    
private:

    ListT<Chain> _attrList;
    ListT<Chain> _valList; 
};



class MyConfirm : public Screen::Confirm
{
public:
    
    
    Screen::Panel* onConfirm() {

	for ( unsigned i = 100; i > 0 ; i-- )
	{
	    if ( i == 100 )
	    {
		setStatus(Chain("Confimed level XXXXXXXXXXXXX"));
		Sleeper::milliSleep(200);
	    }
	    setStatus(Chain("Confimed level ") + Chain(i));
	    Sleeper::milliSleep(10);
	}
	return _pParent;
    }

    Screen::Panel* onCancel() {
	setStatus(Chain("Confirm panel canceled"));
	return _pParent;
    }

    MyConfirm(Screen::Panel* pParent, const Chain& title, const Chain& details)
	: Screen::Confirm(pParent) {
	setInfo(title, details);
    }    	    
};



int main(int argc, char **argv) 
{ 
   
    try
    { 

	Screen sc;

	sc.setTimeout(3000);

	Screen::Menu* pMenu = new Screen::Menu();
	
	sc.setRoot(pMenu);
	
	MyMessage* pMsg = new MyMessage(pMenu, Chain("MyTitle"), Chain("This is a long\nXXXX\nYYYYY\nZZZ\nAAAA\nBBBB\nmessage\nwith newline"));
	pMenu->regItem(Chain("Message"), (Screen::Panel*)pMsg);

	
	MySelect* pSelect = new MySelect(pMenu, Chain("Select item"));
	pMenu->regItem(Chain("Select"), (Screen::Panel*)pSelect);

	
	/////////////////
	// Grid Sample //
	/////////////////

	MyGrid* pGrid = new MyGrid(pMenu, Chain("Sample Grid"));
	pMenu->regItem(Chain("Grid"), (Screen::Panel*)pGrid);


	/////////////////
	// Form Sample //
	/////////////////
	
	MyForm* pForm = new MyForm(pMenu);
	pMenu->regItem(Chain("Form"), (Screen::Panel*)pForm);


	//////////////////////
	// Attribute Sample //
	//////////////////////
	

	MyAttr* pAttr = new MyAttr(pMenu, Chain("Sample Attribute"));
	pMenu->regItem(Chain("Attr"), (Screen::Panel*)pAttr);


	////////////////////
	// Confirm Sample //
	////////////////////
	
	MyConfirm* pConf = new MyConfirm(pMenu, Chain("Sample Confirm"), Chain("Confirmation details"));
	pMenu->regItem(Chain("Confirm"), (Screen::Panel*)pConf);

	pMenu->regItem(Chain("Quit"), (Screen::Panel*)0);
		
	sc.showScreen();

	delete pForm;
	delete pGrid;
	delete pMsg;
	delete pAttr;
	delete pConf;
	delete pSelect;
	
	
	
    } 
    catch (Exception e) 
    { 
        Chain msg; 
        e.pop(msg); 
        cout << msg << endl; 
        return 1; 
    } 

    cout << "Demo finished" << endl;
    return 0; 

} 
