///////////////////////////////////////////////////////////////////////////////
//                                                         
// SetTest.cc - Testing the SetT template
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2002 by Bjoern Lemke                        
//
// IMPLEMENTATION MODULE
//
// 
// 
// Description: Testing the SetT class
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/BigInteger.h"
#include "../src/Chain.h"
#include "../src/SetT.h"

#include <stdlib.h>
#include <unistd.h>

ostream& operator << (ostream& s, SetT<int>& x)
{

     int* pElement = x.First();
  
     s << "{";
     
     while (pElement)
     {      
	  s << *pElement ;
	  pElement = x.Next(); 
	  if (pElement)
	       s << ",";
     }
     s << "}";
     
     return s;
  
}

int main(int argc, char **argv)
{

    int numCheck = 9;
    int checkCount = 1;
    
    try
    {
	
	cout << "1.." << numCheck << endl;
		
	SetT<int> intSet;
	SetT<Chain> chainSet;
	
	srand(42);
	
	unsigned long count;
	
	for ( int i = 1 ; i < 3 ; i++ )
	{
	    intSet.Empty();
	    chainSet.Empty();
	    
	    count = 1000;      
	    while ( count > 0 )
	    {
		intSet.Insert( rand() % 100 );
		chainSet.Insert( Chain(rand() % 100 ) );
		count--;
	    }
	    
	    count = 1000;
	    
	    while ( count > 0 )
	    {
		intSet.Remove( rand() % 100 );
		chainSet.Remove( Chain(rand() % 100 ) );
		count--;	 
	    }
	    
	    
	    while ( count > 0 )
	    {
		intSet.Find( rand() % 100 );
		chainSet.Find( Chain(rand() % 100 ) );
		count--;	 
	    }
	    
	    int* pI = intSet.First();
	    while ( pI )
	    {
		pI = intSet.Next();
	    }
	    Chain* pS = chainSet.First();
	    while ( pS )
	    {
		pS = chainSet.Next();
	    }
	}

	cout << "ok " << checkCount << " - Insert/Remove/Find/Trace" << endl;
	checkCount++;
	
	intSet.Empty();
	chainSet.Empty();

	cout << "ok " << checkCount << " - Empty" << endl;
	checkCount++;
		
	SetT<int> intSet2;
	intSet2 = intSet;
	
	SetT<Chain> chainSet2;
	chainSet2 = chainSet;
	
	cout << "ok " << checkCount << " - copy" << endl;
	checkCount++;

	
	SetT<int> intSet3;
	SetT<Chain> chainSet3;
	
	intSet3.Insert(9999);
	chainSet3.Insert("9999");
	
	
	intSet = intSet2 + intSet3;
	chainSet = chainSet2 + chainSet3;

	cout << "ok " << checkCount << " - add" << endl;
	checkCount++;

	intSet = intSet2 - intSet3;
	chainSet = chainSet2 - chainSet3;
	
	cout << "ok " << checkCount << " - sub" << endl;
	checkCount++;

	
	intSet += intSet3;
	chainSet += chainSet3;

	cout << "ok " << checkCount << " - concat" << endl;
	checkCount++;
	
	
	intSet ^= intSet3;
	chainSet ^= chainSet3;

	cout << "ok " << checkCount << " - intersection" << endl;
	checkCount++;


	intSet = intSet3;
	if ( intSet == intSet3 == false )
	    throw Exception(EXLOC, "int compare failed");
	
	chainSet = chainSet3;
	if ( chainSet == chainSet3 == false )
	    throw Exception(EXLOC, "chain compare failed");

	cout << "ok " << checkCount << " - comparison" << endl;
	checkCount++;
	
	intSet.Size();
	chainSet.Size();

	cout << "ok " << checkCount << " - size" << endl;
	checkCount++;

	
	intSet.isEmpty();
	chainSet.isEmpty();

    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;
}

