#ifndef _AESCRPYPT_H_INCLUDED_
#define _AESCRPYPT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// AESCrypt.h
// ----------
// AES encryption class
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2010-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: AESCrpyt
// 
// Description: AES encryption
//              The code has been derived from
//
//              Niyaz PK
//              E-mail: niyazpk@gmail.com
//              Downloaded from Website: www.hoozi.com
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "Chain.h"

class AESCrypt {

public:
  
    AESCrypt();
    AESCrypt(const Chain& key, unsigned keyLen);
    ~AESCrypt();

    Chain encrypt(const Chain& val);
            
private:
    
    unsigned char getSBoxValue(unsigned num);
    unsigned char getRconValue(unsigned num);
    
    void KeyExpansion();
    void AddRoundKey(unsigned round);
    void SubBytes();
    void ShiftRows();
    void MixColumns();
    void Cipher();
    unsigned char xtime(unsigned char x);
    
    unsigned _Nr;
    unsigned _Nk;
    
    // in - it is the array that holds the plain text to be encrypted.
    // out - it is the array that holds the output CipherText after encryption.
    // state - the array that holds the intermediate results during encryption.
    unsigned char _in[16], _out[16], _state[4][4];
    
    // The array that stores the round keys.
    unsigned char _RoundKey[240];
    
    // The Key input to the AES Program
    unsigned char _Key[32];    
};
#endif



