#ifndef _CRYPT_H_INCLUDED_
#define _CRYPT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Crypt.h
// --------
// Crypt class definition
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: Crypt
// 
// Description: This code is based upon C source code written by Eric Young, eay@psych.uq.oz.au                                        
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES

#include "Chain.h"

class Crypt {

public:
    
    Crypt(const Chain& key);
    Crypt(const Chain& key, const Chain& salt);
    ~Crypt();
    
    Chain getEncryption();

    Crypt& operator = ( const Crypt& cy);
    bool operator == ( const Crypt& cy) const;
  
private:

    int byteToUnsigned(char b);
    int fourBytesToInt(char b[], int offset);
    void intToFourBytes(int iValue, char b[], int offset);
    void PERM_OP(unsigned int a, unsigned int b, int n, int m, unsigned int results[]);
    unsigned int HPERM_OP(unsigned int a, int n, unsigned int m);
    int* des_set_key(char key[]);
    unsigned int D_ENCRYPT(unsigned int L, unsigned int R, unsigned int S, unsigned int E0, unsigned int E1, int s[]);
    int* body(int schedule[], unsigned int Eswap0, unsigned int Eswap1);
    Chain ey_crypt(Chain salt, Chain original);

    Chain _key;
    Chain _salt;
};

#endif



