#ifndef _FILE_H_INCLUDED_
#define _FILE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// File.h
// ------
// File class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// INTERFACE MODULE
//
// Class: File
//
// Description: Utility class for operations on files 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES

#include "Chain.h"

#define MAXLINELEN 1024
#define READBUFSIZE 1024

class File {
 
 public:

    enum StdStream { IN, OUT };  
    enum Mode { CLOSED, READ, WRITE, READWRITE, APPEND };  

    File();
    File(StdStream s);    
    File(char* s);
    File(const Chain& str);
    ~File();
    
    static bool exists(const Chain& fileName);
    bool exists();
    
    void open(Mode m);
    void flush();
    void close();

    bool hasData(int timeout) const;
	
    void writeByte(char *buf, unsigned long long buflen);
    unsigned long long readByte(char *buf, unsigned long long buflen);
    
    void writeChain(const Chain& str);
    unsigned long long readLine(Chain& line, unsigned long long maxLen = MAXLINELEN);
    
    void seek(unsigned long long pos);
    
    void trunc(unsigned long long size);
    
    void rename(const Chain& fileName);
    void remove();
    
    unsigned long long Size() const;

    const Chain& getFileName() const;
    Chain getShortName() const;
    
    File& operator =  ( File& f);
    File& operator += ( File& f);
    
    File& operator << ( const Chain& str);
    File& operator << ( long l);
    File& operator << ( long long l);
    File& operator << ( unsigned long l);
    File& operator << ( unsigned long long l);
    File& operator << ( int i);
    File& operator << ( unsigned l);
    File& operator << ( char c);
    
private:

    char nextChar();
    
    int _fd;
    Mode _mode;
    Chain _filename;

    unsigned long long _readPos;
    unsigned long long _readBufLen;    
    char _readBuf[READBUFSIZE];
    char* _lineBuf;
    unsigned long long _lineBufLen;
};
#endif
