///////////////////////////////////////////////////////////////////////////////
//                                                         
// Process.cc
// ----------
// Process class implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: Process
//
// Description: Utility class for POSIX process handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _REENTRANT
#define _REENTRANT    /* basic 3-lines for threads */
#endif

#include "Process.h"

// SYSTEM INCLUDES

#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
 
#include "Exception.h"
#include "Chain.h"

Process::Process()
{
}

Process::~Process()
{
}

int Process::getPid() const
{
    int pid;
    if ( ( pid = ::getpid())  == -1 )
    {
	Chain msg = Chain("getpid system error : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }
    return pid;
}

void Process::kill(int sig) const
{
    int pid = getPid();
   
#ifndef HAVE_MINGW
    if ( ( ::kill(pid, sig))  == -1 )
    {
	Chain msg = Chain("kill system error : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }
#endif

    return;
}

