///////////////////////////////////////////////////////////////////////////////
//                                                         
// Sleeper.cc
// ----------
// Sleeper class implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: Sleeper
// 
// Description: Sleeper class implementation
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _REENTRANT
#define _REENTRANT    /* basic 3-lines for threads */
#endif

#include "Sleeper.h"

// SYSTEM INCLUDES
#include <time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "Exception.h"
#include "Chain.h"

Sleeper::Sleeper()
{
}

Sleeper::~Sleeper()
{
}

void Sleeper::secSleep(unsigned int n)
{
    ::sleep(n);
}

void Sleeper::milliSleep(unsigned long n)
{

    unsigned long ms = n % 1000;
    unsigned long sec = n / 1000;

    struct timespec delay;
    delay.tv_sec = sec;
    delay.tv_nsec = ms * 1000000l;
    if ( nanosleep(&delay, NULL) == -1 )
    {
	Chain msg = Chain("nanosleep system error : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }
}

void Sleeper::microSleep(unsigned long n)
{
    unsigned long us = n % 1000000;
    unsigned long sec = n / 1000000;
    
    struct timespec delay;
    delay.tv_sec = sec;
    delay.tv_nsec = us * 1000l;
    if ( nanosleep(&delay, NULL) == -1 )
    {
	Chain msg = Chain("nanosleep system error : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }
}

void Sleeper::nanoSleep(unsigned long n)
{
    struct timespec delay;
    delay.tv_sec = 0;
    delay.tv_nsec = n;
    if ( nanosleep(&delay, NULL) == -1 )
    {
	Chain msg = Chain("nanosleep system error : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }
}
