#ifndef _THREADLOCK_H_INCLUDED_
#define _THREADLOCK_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// ThreadLock.h
// ------------
// ThreadLock class interface definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// INTERFACE MODULE
//
// Class: ThreadLock
// 
// Description: All operations on POSIX thread locks
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _REENTRANT
#define _REENTRANT    /* basic 3-lines for threads */
#endif

// POSIX includes
#include <pthread.h>

// lfcbase includes
#include "Chain.h"

#define LOCKDELAY 100

class ThreadLock 
{
    
public:

    ThreadLock(const Chain& id = "");
    ~ThreadLock();

    const Chain& getId() const;
    void setId(const Chain& id);

    void init(unsigned lockDelay = LOCKDELAY, bool doStat = false);
    void readLock();
    void writeLock();

    void readLock(unsigned timeout);
    void writeLock(unsigned timeout);
    
    void unlock();

    unsigned numLockTry();
    
    unsigned long long numReadLock();
    unsigned long long numWriteLock();
    unsigned long long sumReadDelay();
    unsigned long long sumWriteDelay();

private:

    Chain _id;
    unsigned _lockDelay;

    pthread_rwlock_t _rwlock;
    pthread_rwlock_t _statlock; 

    bool _doStat;

    unsigned long long _readLockCount;
    unsigned long long _writeLockCount;
    unsigned long long _readDelay;
    unsigned long long _writeDelay;

    unsigned _numLockTry;

};
#endif
