#ifndef _TIMER_H_INCLUDED_
#define _TIMER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Timer.h
// --------
// Timer class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
// 
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// INTERFACE MODULE
//
// Class: Timer 
// 
// Description: Timer class for time measurement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////


// INCLUDES
#include <sys/time.h>
#include "Chain.h"

class Timer {

public:
    
    Timer(unsigned s = 6, unsigned p = 6);
    ~Timer();
    void start();
    void stop();

    Chain getUsed() const;
    
    long getSumSec() const;
    long getSumUSec() const;

    void reset();

    friend ostream& operator << (ostream& s, const  Timer& t);
    
private:

    unsigned _scale;
    unsigned _precision;

    long _sec;
    long _usec;

    long _sumSec;
    long _sumUSec;
};
#endif
