///////////////////////////////////////////////////////////////////////////////
//                                                         
// ChainTest.cc
// -------------
// chain class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Chain.h"

#include <locale.h>

int main(int argc, char **argv)
{

#ifndef HAVE_MINGW
    int numCheck = 21;
#else
    int numCheck = 20;
#endif
    
    int checkCount = 1;
    
    try
    {
	
	cout << "1.." << numCheck << endl;

	// Chain ll("0");
	// cout << ll.asLongLong() << endl;;
	
	// char *locale = setlocale(LC_ALL, "de_DE.UTF-8");
	setlocale(LC_ALL, "de_DE.UTF-8");
	
	Chain bl("Jörn Jürgenson");

	// cout << "Chain=" << bl << endl;
	// cout << "Length=" << bl.length() << endl;
	// cout << "Visible Length=" << bl.visibleLength() << endl;
	
	// cout << bl.toUpper() << endl;

	
	if ( bl.length() == 17 )	    
	    cout << "ok " << checkCount << " - length" << endl;
	else
	    cout << "not ok " << checkCount << " - length" << endl;
	checkCount++;

	
        if ( bl.visibleLength() == 15 )	    
	    cout << "ok " << checkCount << " - visibleLength" << endl;
	else
	    cout << "not ok " << checkCount << " - visibleLength" << endl;
	checkCount++;
	
	Chain hw("Hugo Walter");
        if ( hw.visibleLength() == 12 )	    
	    cout << "ok " << checkCount << " - visibleLength" << endl;
	else
	    cout << "not ok " << checkCount << " - visibleLength" << endl;
	checkCount++;
	       
	hw.getHashPos(10);
	cout << "ok " << checkCount << " - getHashPos" << endl;
	checkCount++;
		
	Chain s("This is the chain to replace and replace and replaceY");
	Chain pattern("%y%");
	Chain sqlPattern = Chain("^") + pattern + Chain("$");	
	sqlPattern.replaceAll(Chain("%"), Chain(".*"), sqlPattern);
	sqlPattern.replaceAll(Chain("_"), Chain("."), sqlPattern);
       
	cout << "ok " << checkCount << " - replace" << endl;
	checkCount++;

	char buf[20];
	unsigned long l=42;
	int i=42;
	float f=42.0;
	double d=42.0;
	
	Chain s1;
	Chain s2(buf);
	Chain s3(buf, 20);
	Chain s4(s1);
	Chain s5('c');
	Chain s6(l);
	Chain s7(i);
	Chain s8(f);
	Chain s9(d);
	cout << "ok " << checkCount << " - constructors" << endl;
	checkCount++;
	
	Chain s10 = Chain("XXXergoDASDSAY");
	
	if ( s10.cutTrailing(" ").subChain(s10.length()-1,s10.length()-1) == Chain("Y"))
	    cout << "ok " << checkCount << " - cutTrailing/subChain" << endl;
	else
	    cout << "not ok " << checkCount << " - cutTrailing/subChain" << endl;
	checkCount++;
	
	s10.length();
	s10.toUpper();
	s10.toLower();
	// s10.asInteger();
	// s8.asBool();
	s10.isNum();
	s10.cutTrailing("YYY");
	s10.truncLeft("YYY");
	s10.truncRight("CCC");
	unsigned long pos;
	s10.posStr("ergo", pos);
	Chain res;
	s10.replace("A", "B", res);

	cout << "ok " << checkCount << " - others" << endl;
	checkCount++;
	
	Chain s11 = Chain("3.457");
	
	s11.asFloat();	
	cout << "ok " << checkCount << " - asFloat" << endl;
	checkCount++;

	s11.asDouble();	
	cout << "ok " << checkCount << " - asDouble" << endl;
	checkCount++;


	Chain s12 = Chain("X");
	if ( s12.cutTrailing(" \t").subChain(s12.length()-1,s12.length()-1) == Chain("X"))
	    cout << "ok " << checkCount << " - cutTrailing/subChain" << endl;
	else
	    cout << "not ok " << checkCount << " - cutTrailing/subChain" << endl;
	checkCount++;

	Chain s13 = Chain("X");
	if ( s13.truncLeft(" \t") == Chain("X"))
	    cout << "ok " << checkCount << " - truncLeft" << endl;
	else
	    cout << "not ok " << checkCount << " - truncLeft" << endl;
	checkCount++;

	Chain s14 = Chain("X");	
	if ( s14.truncRight(" \t") == Chain("X"))
	    cout << "ok " << checkCount << " - truncRight" << endl;
	else
	    cout << "not ok " << checkCount << " - truncRight" << endl;
	checkCount++;

	Chain s15 = Chain("X");
	if ( s15.cutTrailing(" \t") == Chain("X"))
	    cout << "ok " << checkCount << " - cutTrailing" << endl;
	else
	    cout << "not ok " << checkCount << " - cutTrailing" << endl;
	checkCount++;
	
	Chain s16 = Chain("1234");

	if ( s16.asShort() == 1234 )
	    cout << "ok " << checkCount << " - asShort" << endl;
	else
	    cout << "not ok " << checkCount << " - asShort" << endl;
	checkCount++;
	
	if ( s16.asInteger() == 1234 )
	    cout << "ok " << checkCount << " - asInteger" << endl;
	else
	    cout << "not ok " << checkCount << " - asInteger" << endl;
	checkCount++;

	if ( s16.asLong() == 1234 )
	    cout << "ok " << checkCount << " - asLong" << endl;
	else
	    cout << "not ok " << checkCount << " - asLong" << endl;
	checkCount++;

	if ( s16.asUnsignedLong() == 1234 )
	    cout << "ok " << checkCount << " - asUnsignedLong" << endl;
	else
	    cout << "not ok " << checkCount << " - asUnsignedLong" << endl;
	checkCount++;

	if ( s16.asLongLong() == 1234 )
	    cout << "ok " << checkCount << " - asLongLong" << endl;
	else
	    cout << "not ok " << checkCount << " - asLongLong" << endl;
	checkCount++;

	if ( s16.asUnsignedLongLong() == 1234 )
	    cout << "ok " << checkCount << " - asUnsignedLongLong" << endl;
	else
	    cout << "not ok " << checkCount << " - asUnsignedLongLong" << endl;
	checkCount++;

	Chain s17 = Chain("0x9");

	if ( s17.asInteger() == 9 )
	    cout << "ok " << checkCount << " - asInteger" << endl;
	else
	    cout << "not ok " << checkCount << " result = " << s17.asInteger() << " - asInteger" << endl;
	checkCount++;

	
    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;
       
}

