///////////////////////////////////////////////////////////////////////////////
//                                                         
// HashTest.cc - Testing the HashT template
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2021 by Bjoern Lemke                        
//
// IMPLEMENTATION MODULE
//
// Description: Testing the SetT class
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Chain.h"
#include "../src/HashT.h"

#include <stdlib.h>
#include <unistd.h>

ostream& operator << (ostream& s, HashT<Chain>& hs)
{

     Chain* pElement = hs.First();
  
     s << "HashSet :" << endl;
     
     while (pElement)
     {      
	 s << hs.getPos() << " : " << *pElement << endl;
	 pElement = hs.Next(); 	 
     }
     
     return s;
  
}

int main(int argc, char **argv)
{

    int numCheck = 5;
    int checkCount = 1;
    
    try
    {
	
	cout << "1.." << numCheck << endl;
		
	HashT<Chain> chainHash(30,3);
	

	chainHash.Empty();
	chainHash.Insert(Chain("Alpha"));
	// cout << "After insert of alpha :" << endl;

	chainHash.Insert(Chain("Beta"));
	chainHash.Insert(Chain("Gamma"));
	chainHash.Insert(Chain("Gammi"));
	chainHash.Insert(Chain("Gammo"));
	chainHash.Insert(Chain("Gammu"));
	chainHash.Insert(Chain("Hugo"));
	chainHash.Insert(Chain("Erna"));
	chainHash.Insert(Chain("Jakob"));
	chainHash.Insert(Chain("Peter"));
	chainHash.Insert(Chain("Paul"));
	chainHash.Insert(Chain("Willy"));
	chainHash.Insert(Chain("Iwan"));
	chainHash.Insert(Chain("Heidi"));
	chainHash.Insert(Chain("Lore"));

	// cout << chainHash << endl;
	
	// chainHash.Size();

	/*
	if ( chainHash.Find(Chain("Erna")))
	    cout << "Found Erna" << endl;
	if ( chainHash.Find(Chain("Heidi")))
	    cout << "Found Heid" << endl;
	if ( chainHash.Find(Chain("Kurt")))
	    cout << "Found Kurt" << endl;
	*/
	if ( chainHash.Find(Chain("Erna")))	
	    cout << "ok " << checkCount << " - find" << endl;
	else
	    cout << "not ok " << checkCount << " - find" << endl;
	checkCount++;

	if ( chainHash.Find(Chain("Willy")))	
	    cout << "ok " << checkCount << " - find" << endl;
	else
	    cout << "not ok " << checkCount << " - find" << endl;
	checkCount++;

	if ( chainHash.Find(Chain("Lore")))	
	    cout << "ok " << checkCount << " - find" << endl;
	else
	    cout << "not ok " << checkCount << " - find" << endl;
	checkCount++;	

	
	// delete hash array
	
	Chain *pC = chainHash.First();
	while ( pC )
	{
	    // cout << "Cleaning entry" << *pC << endl;	   	    
	    chainHash.Remove(*pC);
	    pC = chainHash.First();		
	}

	if ( chainHash.numEntry() == 0)	
	    cout << "ok " << checkCount << " - Remove" << endl;
	else
	    cout << "not ok " << checkCount << " - Remove " << endl;
	checkCount++;



	chainHash.Insert(Chain("Beta"));
	chainHash.Insert(Chain("AAAA"));
	chainHash.Insert(Chain("AXZFD"));
	
	chainHash.Insert(Chain("Gammi"));
	chainHash.Insert(Chain("Gammo"));
	chainHash.Insert(Chain("Gammu"));
	chainHash.Insert(Chain("Hugo"));

	// cout << chainHash << endl;

	int findInRange=0;
	Chain *pR = chainHash.FirstInRange(Chain("Beta"));
	while ( pR )
	{
	    findInRange++; // cout << "Found " << *pR << endl;
	    pR = chainHash.NextInRange();		
	}


	if ( findInRange == 3)	
	    cout << "ok " << checkCount << " - FindInRange" << endl;
	else
	    cout << "not ok " << checkCount << " - FindInRange " << endl;
	checkCount++;


    }
    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;
}

