///////////////////////////////////////////////////////////////////////////////
//                                                         
// Bitmap.cc
// ---------
// Bitmap management 
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: Bitmap
// 
// Description: This class provides bitmap management for boolean data
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>

// INCLUDES
#include "Bitmap.h"
#include "Exception.h"

#define BIT_PER_BYTE 8

Bitmap::Bitmap(unsigned size)
{    
    _size = size;
    _pBM = (char*)malloc(size / (BIT_PER_BYTE * sizeof(char)) + 1);
     
     if ( _pBM == 0 ) 
     {
	 throw Exception(EXLOC, "malloc system error"); 
     }

     for (unsigned i = 0; i < (unsigned)(size / (BIT_PER_BYTE * sizeof(char)) + 1); i++)
     {
	 _pBM[i]=0;
     }
}

Bitmap::~Bitmap()
{
    if ( _pBM)
	free(_pBM);
}

void Bitmap::setValue(unsigned pos, bool val)
{

    if ( pos < _size )
    {
	unsigned bmid = pos / ( BIT_PER_BYTE * sizeof(char));
	char bmoffset = pos % ( BIT_PER_BYTE * sizeof(char));
	
	// cout << "bmid is " << bmid << endl;
	// cout << "offset is " << (int)bmoffset << endl;
	
	char f = ~(~(unsigned)0 << 1);
	f = f << bmoffset;
	
	_pBM[bmid] = _pBM[bmid] | f;
    }
    else
    {
	throw Exception(EXLOC, "bitmap position exceeded"); 
    }
}

bool Bitmap::getValue(unsigned pos) const
{
    if ( pos < _size )
    {
	unsigned bmid = pos / ( BIT_PER_BYTE * sizeof(char));
	char bmoffset = pos % ( BIT_PER_BYTE * sizeof(char));
	
	char checkbit = _pBM[bmid] >> bmoffset & ~(~(unsigned)0 << 1);    
	
	if (  checkbit )
	{
	    return true;
	}
	return false;
    }
    throw Exception(EXLOC, "bitmap position exceeded"); 

}

Chain Bitmap::toChain() const
{
    Chain s;
    for (unsigned i = 0; i < _size; i++)
    {	
	if ( getValue(i) )
	{
	    s += "1";
	}
	else
	{
	    s += "0";
	}
    }   
    return s;
}

Bitmap& Bitmap::operator = ( const Bitmap& bm)
{
    if ( _pBM )
	free(_pBM);    
    _size = bm._size;
    _pBM = (char*)malloc(_size / (BIT_PER_BYTE * sizeof(char)) + 1);
     
     if ( _pBM == 0 ) 
     {
	 throw Exception(EXLOC, "malloc system error"); 
     }

     for (unsigned i = 0; i < (unsigned)(_size / (BIT_PER_BYTE * sizeof(char)) + 1); i++)
     {
	 _pBM[i]=bm._pBM[i];
     }

     return (*this);    
}

bool Bitmap::operator == ( const Bitmap& bm) const
{
    if ( _size != bm._size )
	return false;

    for (unsigned i = 0; i < (unsigned)(_size / (BIT_PER_BYTE * sizeof(char)) + 1); i++)
    {
	if ( _pBM[i] != bm._pBM[i] )
	    return false;
	    
    }

    return true;
}
