///////////////////////////////////////////////////////////////////////////////
//                                                         
// GetLongOpt.cc
// -------------
// GetLongOpt class implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: GetLongOpt
//
// Description: Handling long arguments from the command line
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// POSIX INCLUDES
#include <string.h>

// LFC INCLUDES
#include "GetLongOpt.h"
#include "Chain.h"
#include "Exception.h"
#include "Tokenizer.h"

GetLongOpt::GetLongOpt(unsigned argc, char** argv)
{
    _argc = argc;
    _argv = argv;
    _isParsed = false;
}

GetLongOpt::~GetLongOpt()
{
}

void GetLongOpt::addOpt(const Chain& opt)
{
    _optHash.Insert(OptHash(opt));
}

void GetLongOpt::addOpt(const Chain& opt, const Chain& defVal)
{
    _optHash.Insert(OptHash(opt, defVal));
}

Chain GetLongOpt::getOptValue(const Chain& opt)
{
    if ( _isParsed == false )
    {
	parseOpt();
    }

    OptHash *pOH =  _optHash.Find(OptHash(opt));
    if ( pOH )
	return pOH->getValue();
    
    Chain msg = Chain("Invalid option ") + opt;		    
    throw Exception(EXLOC, msg);
}

bool GetLongOpt::isSet(const Chain& opt)
{
    if ( _isParsed == false )
    {
	parseOpt();
    }

    OptHash *pOH = _optHash.Find(OptHash(opt));
    if ( pOH )
	return pOH->isSet();
    
    Chain msg = Chain("Invalid option ") + opt;		    
    throw Exception(EXLOC, msg);
    
}

void GetLongOpt::parseOpt()
{    
    unsigned optPos = 1;
    while (optPos < _argc )
    {
	Tokenizer tok(Chain(_argv[optPos]), Chain("="));
	Chain opt;
	if ( tok.nextToken(opt) )
	{
	    opt = opt.cutTrailing("-");
	    OptHash *pOH = _optHash.Find(OptHash(opt));
	    if ( pOH == 0)
	    {
		Chain msg = Chain("Invalid option ") + opt;		    
		throw Exception(EXLOC, msg);
	    }

	    pOH->set();
		
	    Chain val;
	    if ( tok.nextToken(val) )
	    {
		// treat the case, that the option string contains '=' characters
		Chain optTail;
		tok.getTail(optTail);
		
		val += optTail;
		
		pOH->setValue(val);
	    }
	}
	optPos++;
    }
    _isParsed = true;
}
