#ifndef _NETHANDLER_H_INCLUDED_
#define _NETHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// NetHandler.h
// ------------
// Net handler for sending and receiving messages
//                                                         
// (C)opyright 2000-2013 Bjoern Lemke
//
// Design and Implementation by Bjoern Lemke               
//
// INTERFACE MODULE
//
// Class: NetHandler
// 
// Description: Net handle for sending and receiving messages
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////


#include "Chain.h"
#include "ListT.h"

class NetHandler {
    
public:
    
    NetHandler(int s, unsigned initMsgBufLen, unsigned sizeInfoLen, unsigned maxSendLen);    
    ~NetHandler();

    bool waitMsg(unsigned ms);

    int getSocket();
    
    void setSource(const Chain& source);
    const Chain& getSource() const;
    
    void writeMsg();
    void readMsg();


    void sendAck();
    void sendNack();
    bool recvAck();

    void sendChar(char c);
    char recvChar();
    
    char* getMsg();
    unsigned getMsgSize();

    void setMsg(char* msg, unsigned size);

    unsigned concatPos();
    void concatReset();
    void concatAdd(const Chain& s);
    void concatAdd(char* msg, unsigned size);

    void disconnect();
    
    NetHandler& operator = ( const NetHandler& nh);
    bool operator == ( const NetHandler& nh) const;

private:

    char* _msgBuf;
    unsigned _msgBufSize;
    unsigned _msgSize;
    unsigned _sizeInfoLen;
    unsigned _maxSendLen;
    int _socket;

    unsigned _concatPos;

    Chain _source;
};

#endif
