///////////////////////////////////////////////////////////////////////////////
//                                                         
// OutStream.cc
// ------------
// Executing commands via process forking 
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2017 Bjoern Lemke                        
//
// IMPLEMENTATION MODULE
//
// Class: CommandExecuter
// 
// Description: Execution of a forked sub program 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// SYSTEM INCLUDES 
#include <stdio.h> 
#include <string.h> 
#include <errno.h> 
#include <stdlib.h>
#include <sys/wait.h>

// BASE INCLUDES
#include "OutStream.h"
#include "Exception.h"
#include "File.h"

OutStream::OutStream()
{
    _errorCode = 0;
}

OutStream::~OutStream()  
{
}

void OutStream::open(const Chain& command)
{

    Chain streamResult;
    
    FILE *outStream;

    char buff[512];

    if (! ( outStream = popen((char*)command, "r")))
    {	
	Chain msg = Chain("Cannot execute command <") + command + Chain("> : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }

    bool goOn = true;
    while( fgets(buff, sizeof(buff), outStream ) != NULL && goOn )
    {
	Chain line(buff);
	// line = line.cutTrailing("\n");
	goOn = nextLine( line );
    }

    int status = pclose(outStream);


    _errorCode = WEXITSTATUS(status);
    
    if ( _errorCode != 0 )
    {
	Chain msg = Chain("Stream command failed with error code " + Chain(_errorCode));
	throw Exception(EXLOC, msg);	
    }

    return;

}

int OutStream::getErrorCode() const
{
    return _errorCode;
}
