#ifndef _XMLINSTREAM_H_INCLUDED_
#define _XMLINSTREAM_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//
// XMLInStream.h
// -------------
// XML Instream abstract class
//               
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: XMLInStream
// 
// Description: XML input stream abstract class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include "Attribute.h"
#include "Element.h"

class XMLInStream {
 
 public:
  
    XMLInStream();
    virtual ~XMLInStream();
    
    virtual void putFirst(Element *pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*>& dataList ) = 0;
    virtual void putNext(Element *pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*>& dataList) = 0;
     
 private:
  
};
#endif
